/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseImportInput;
import com.jaspersoft.jasperserver.export.io.FileSystemInputManager;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemInput
extends BaseImportInput {
    private static final Log log = LogFactory.getLog(FileSystemInput.class);
    private final String rootDirName;
    private final FileSystemInputManager manager;
    private PathProcessor pathProcessor;
    private File rootDir;

    public FileSystemInput(String rootDir, PathProcessor pathProcessor, FileSystemInputManager manager) {
        this.rootDirName = rootDir;
        this.pathProcessor = pathProcessor;
        this.manager = manager;
    }

    @Override
    public void open() {
        this.rootDir = new File(this.rootDirName);
        if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
            throw new JSException("jsexception.import.directory.not.found", new Object[]{this.rootDirName});
        }
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getFileInputStream(String path) {
        try {
            File file = this.getFile(path);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            return in;
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected File getFile(String path) {
        String fsPath = this.pathProcessor.processPath(path);
        File file = new File(this.rootDir, fsPath);
        return file;
    }

    @Override
    public boolean fileExists(String path) {
        File file = this.getFile(path);
        return file.exists() && file.isFile();
    }

    @Override
    public boolean folderExists(String path) {
        File file = this.getFile(path);
        return file.exists() && file.isDirectory();
    }

    public void setPathProcessor(PathProcessor pathProcessor) {
        this.pathProcessor = pathProcessor;
    }

    @Override
    public void propertiesRead(Properties properties) {
        this.manager.updateInputProperties(this, properties);
    }
}

