/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.BaseExportOutput;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipFileOutput
extends BaseExportOutput {
    private static final Log log = LogFactory.getLog(ZipFileOutput.class);
    protected static final String ZIP_ENTRY_DIR_SUFFIX = "/";
    private final String zipFile;
    private final int level;
    private final PathProcessor pathProcessor;
    private Set directories;
    protected ZipOutputStream zipOut;

    public ZipFileOutput(String zipFile, int level, PathProcessor pathProcessor, Properties outputProperties) {
        super(outputProperties);
        this.zipFile = zipFile;
        this.level = level;
        this.pathProcessor = pathProcessor;
    }

    @Override
    public void open() {
        try {
            BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(this.zipFile));
            this.zipOut = new ZipOutputStream(fileOut);
            this.zipOut.setLevel(this.level);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        this.directories = new HashSet();
    }

    @Override
    public void close() throws IOException {
        this.zipOut.finish();
        this.zipOut.close();
    }

    @Override
    public OutputStream getFileOutputStream(String path) throws IOException {
        String zipPath = this.getZipPath(path);
        ZipEntry fileEntry = new ZipEntry(zipPath);
        this.zipOut.putNextEntry(fileEntry);
        EntryOutputStream entryOut = new EntryOutputStream();
        return entryOut;
    }

    protected String getZipPath(String path) {
        String zipPath = this.pathProcessor.processPath(path);
        return zipPath;
    }

    @Override
    public void mkdir(String path) throws IOException {
        if (this.directories.add(path)) {
            String zipPath = this.getZipPath(path);
            ZipEntry dirEntry = new ZipEntry(zipPath + ZIP_ENTRY_DIR_SUFFIX);
            this.zipOut.putNextEntry(dirEntry);
            this.zipOut.closeEntry();
        }
    }

    protected class EntryOutputStream
    extends OutputStream {
        protected EntryOutputStream() {
        }

        @Override
        public void close() throws IOException {
            ZipFileOutput.this.zipOut.closeEntry();
        }

        @Override
        public void flush() throws IOException {
            ZipFileOutput.this.zipOut.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ZipFileOutput.this.zipOut.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            ZipFileOutput.this.zipOut.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            ZipFileOutput.this.zipOut.write(b);
        }
    }
}

