/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSourceModel;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImporter;
import com.jaspersoft.jasperserver.export.modules.scheduling.SchedulingModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobBean;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportUnitJobsIndexBean;
import com.jaspersoft.jasperserver.export.util.PathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;

public class ReportJobsImporter
extends BaseImporterModule {
    private static final Log log = LogFactory.getLog(ResourceImporter.class);
    protected SchedulingModuleConfiguration configuration;
    private String prependPathArg;
    protected String prependPath;
    private Map userIndicator;
    private static String SYS_DUP_SUFFIX = "_SYSDUP_";

    @Override
    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.prependPath = this.getPrependPath();
    }

    protected String getPrependPath() {
        String path = this.getParameterValue(this.getPrependPathArg());
        if (path != null) {
            if ((path = PathUtils.normalizePath(path)).length() == 0 || path.equals("/")) {
                path = null;
            } else if (!path.startsWith("/")) {
                path = "/" + path;
            }
        }
        return path;
    }

    @Override
    public List<String> process() {
        this.initProcess();
        Iterator i = this.indexElement.elementIterator(this.configuration.getIndexReportUnitElement());
        while (i.hasNext()) {
            Element ruElement = (Element)i.next();
            String uri = ruElement.getText();
            this.processReportUnit(uri);
        }
        return null;
    }

    protected void initProcess() {
        this.userIndicator = new HashMap();
    }

    protected void processReportUnit(String uri) {
        String newUri = this.prependedPath(uri);
        if (this.checkReportUnit(newUri)) {
            String ruPath = PathUtils.concatPaths(this.configuration.getReportJobsDir(), uri);
            ReportUnitJobsIndexBean indexBean = (ReportUnitJobsIndexBean)this.deserialize(ruPath, this.configuration.getReportUnitIndexFilename(), this.configuration.getSerializer());
            long[] jobIds = indexBean.getJobIds();
            if (this.isUpdateResource(newUri)) {
                ArrayList<ReportJobBean> reportJobBeans = this.getReportJobBeans(ruPath, jobIds);
                int imported = 0;
                int updated = 0;
                for (ReportJobBean reportJobBean : reportJobBeans) {
                    ImportStatus status = null;
                    if (this.findDuplicate(reportJobBean, reportJobBeans)) {
                        status = this.updateReportJob(newUri, reportJobBean, ImportStatus.ADD);
                        ++imported;
                    } else {
                        status = this.updateReportJob(newUri, reportJobBean, ImportStatus.UPDATE);
                        ++updated;
                    }
                    if (status == ImportStatus.ADD) {
                        ++imported;
                        continue;
                    }
                    if (status != ImportStatus.UPDATE) continue;
                    ++updated;
                }
                commandOut.info("Created " + imported + " job(s) for report " + newUri);
                commandOut.info("Updated " + updated + " job(s) for report " + newUri);
            } else {
                int imported = 0;
                for (int i = 0; i < jobIds.length; ++i) {
                    long jobId = jobIds[i];
                    if (!this.importReportJob(newUri, ruPath, jobId)) continue;
                    ++imported;
                }
                commandOut.info("Created " + imported + " job(s) for report " + newUri);
            }
        } else {
            commandOut.warn("Report unit " + newUri + " not found in repository, skipping jobs");
        }
    }

    protected ArrayList<ReportJobBean> getReportJobBeans(String jobsPath, long[] jobIds) {
        ArrayList<ReportJobBean> reportJobBeans = new ArrayList<ReportJobBean>();
        for (int i = 0; i < jobIds.length; ++i) {
            String jobFilename = this.getJobFilename(jobIds[i]);
            reportJobBeans.add((ReportJobBean)this.deserialize(jobsPath, jobFilename, this.configuration.getSerializer()));
        }
        return reportJobBeans;
    }

    private boolean findDuplicate(ReportJobBean reportJob, ArrayList<ReportJobBean> reportJobBeans) {
        for (ReportJobBean reportJobBean : reportJobBeans) {
            if (reportJob == reportJobBean || !reportJob.getLabel().equals(reportJobBean.getLabel())) continue;
            if (reportJob.getCreationDate() == null) {
                return true;
            }
            if (reportJob.getCreationDate().compareTo(reportJobBean.getCreationDate()) != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean checkReportUnit(String uri) {
        PathUtils.SplittedPath splittedPath = PathUtils.splitPath(uri);
        FilterCriteria filter = FilterCriteria.createFilter(ReportUnit.class);
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)splittedPath.parentPath));
        filter.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)splittedPath.name));
        ResourceLookup[] lookups = this.configuration.getRepository().findResource(this.executionContext, filter);
        return lookups != null && lookups.length > 0;
    }

    protected boolean isUpdateResource(String resourceUri) {
        Collection updateResources = (Collection)this.getContextAttributes().getAttribute("updateResources");
        return updateResources != null && updateResources.contains(resourceUri);
    }

    protected boolean importReportJob(String reportUri, String jobsPath, long jobId) {
        boolean imported;
        String jobFilename = this.getJobFilename(jobId);
        ReportJobBean jobBean = (ReportJobBean)this.deserialize(jobsPath, jobFilename, this.configuration.getSerializer());
        if (this.userExists(jobBean.getUsername())) {
            imported = this.importJob(reportUri, jobBean);
        } else {
            commandOut.warn("User " + jobBean.getUsername() + " does not exist, skipping job " + jobBean.getId() + " of report " + reportUri);
            imported = false;
        }
        return imported;
    }

    protected ImportStatus updateReportJob(String reportUri, ReportJobBean jobBean, ImportStatus status) {
        if (this.userExists(jobBean.getUsername())) {
            status = this.updateJob(reportUri, jobBean, status);
        } else {
            commandOut.warn("User " + jobBean.getUsername() + " does not exist, skipping job " + jobBean.getId() + " of report " + reportUri);
            status = ImportStatus.SKIP;
        }
        return status;
    }

    protected String getJobFilename(long jobId) {
        return jobId + ".xml";
    }

    protected boolean userExists(String username) {
        Boolean indicator = (Boolean)this.userIndicator.get(username);
        if (indicator == null) {
            indicator = this.configuration.getAuthorityService().getUser(this.executionContext, username) != null;
            this.userIndicator.put(username, indicator);
        }
        return indicator;
    }

    protected boolean importJob(String newUri, ReportJobBean jobBean) {
        ReportJob job = new ReportJob();
        jobBean.copyTo(job, newUri, this.getConfiguration(), this.executionContext);
        List existingJobs = this.configuration.getReportScheduler().getScheduledJobSummaries(this.executionContext, newUri);
        boolean exist = false;
        for (int i = 0; i < existingJobs.size(); ++i) {
            ReportJobSummary rjs = (ReportJobSummary)existingJobs.get(i);
            long rjId = rjs.getId();
            ReportJob rj = this.configuration.getReportScheduler().getScheduledJob(this.executionContext, rjId);
            if (!rj.equals(job)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            try {
                ReportJob savedJob = this.configuration.getInternalReportScheduler().saveJob(this.executionContext, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created job " + savedJob.getId() + " for report " + newUri + " (old id " + jobBean.getId() + ")"));
                }
                return true;
            }
            catch (JSValidationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipped job for report " + newUri + " (old id " + jobBean.getId() + "). " + e.getErrors().toString()));
                }
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skipped existing job for report " + newUri + " (old id " + jobBean.getId() + ")"));
        }
        return false;
    }

    protected ImportStatus updateJob(String newUri, ReportJobBean jobBean, ImportStatus status) {
        ReportJobModel reportJobModel = new ReportJobModel();
        ReportJobSourceModel sourceModel = new ReportJobSourceModel();
        sourceModel.setReportUnitURI(newUri);
        reportJobModel.setSourceModel(sourceModel);
        reportJobModel.setLabel(jobBean.getLabel());
        if (jobBean.getCreationDate() != null) {
            reportJobModel.setCreationDate(jobBean.getCreationDate());
        }
        boolean updateLabelName = true;
        if (status == ImportStatus.UPDATE) {
            List existingJobs = this.configuration.getReportScheduler().getScheduledJobSummaries(this.executionContext, reportJobModel, 0, -1, ReportJobModel.ReportJobSortType.NONE, true);
            if (existingJobs.size() == 0) {
                status = ImportStatus.ADD;
                updateLabelName = false;
            } else if (existingJobs.size() > 1) {
                status = ImportStatus.ADD;
                updateLabelName = true;
            } else {
                ReportJob reportJob = this.configuration.getReportScheduler().getScheduledJob(this.executionContext, ((ReportJobSummary)existingJobs.get(0)).getId());
                jobBean.copyTo(reportJob, newUri, this.getConfiguration(), this.executionContext);
                try {
                    this.configuration.getReportScheduler().updateScheduledJob(this.executionContext, reportJob);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Updated job " + reportJob.getId() + " for report " + newUri + " (old id " + jobBean.getId() + ")"));
                    }
                    return status;
                }
                catch (JSValidationException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Skipped job for report " + newUri + " (old id " + jobBean.getId() + "). " + e.getErrors().toString()));
                    }
                    return ImportStatus.SKIP;
                }
            }
        }
        if (status == ImportStatus.ADD) {
            ReportJob job = new ReportJob();
            jobBean.copyTo(job, newUri, this.getConfiguration(), this.executionContext);
            if (updateLabelName) {
                job.setLabel(this.createUniqueLabel(job.getLabel(), newUri));
            }
            try {
                job = this.configuration.getInternalReportScheduler().saveJob(this.executionContext, job);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created job " + job.getId() + " for report " + newUri + " (old id " + jobBean.getId() + ")"));
                }
                return status;
            }
            catch (JSValidationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Skipped job for report " + newUri + " (old id " + jobBean.getId() + "). " + e.getErrors().toString()));
                }
                return ImportStatus.SKIP;
            }
        }
        return ImportStatus.SKIP;
    }

    private String createUniqueLabel(String label, String uri) {
        List existingJobs = this.configuration.getReportScheduler().getScheduledJobSummaries(this.executionContext, uri);
        if (!this.findLabel(label, existingJobs)) {
            return label;
        }
        int count = 1;
        String newLabel = new StringBuffer(label).append(SYS_DUP_SUFFIX).append(count).toString();
        while (this.findLabel(newLabel, existingJobs)) {
            newLabel = new StringBuffer(label).append(SYS_DUP_SUFFIX).append(++count).toString();
        }
        return newLabel;
    }

    private boolean findLabel(String label, List<ReportJobSummary> existingJobs) {
        for (ReportJobSummary reportJobSummary : existingJobs) {
            if (!reportJobSummary.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    protected String prependedPath(String uri) {
        return PathUtils.concatPaths(this.prependPath, uri);
    }

    public SchedulingModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SchedulingModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPrependPathArg() {
        return this.prependPathArg;
    }

    public void setPrependPathArg(String prependPathArg) {
        this.prependPathArg = prependPathArg;
    }

    private static enum ImportStatus {
        UPDATE,
        ADD,
        SKIP;

    }
}

