/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.domain.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="errors")
public class ValidationErrorsImpl
implements ValidationErrors,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List errors = new ArrayList();

    public boolean isError() {
        return !this.errors.isEmpty();
    }

    @XmlElement(name="error", type=ValidationErrorImpl.class)
    public List getErrors() {
        return this.errors;
    }

    public void add(ValidationError error) {
        this.errors.add(error);
    }

    public String toString() {
        if (!this.isError()) {
            return "No errors";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.errors.size());
        sb.append(" error(s)\n");
        for (ValidationError error : this.errors) {
            sb.append(error.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    public void removeError(String code, String field) {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ValidationError error = (ValidationError)it.next();
            if (!this.matches(error, code, field)) continue;
            it.remove();
        }
    }

    protected boolean matches(ValidationError error, String code, String field) {
        return code.equals(error.getErrorCode()) && field.equals(error.getField());
    }
}

