/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.Ordered;

public class BeanReferenceOverrider
implements BeanFactoryPostProcessor,
Ordered {
    private static final Log log = LogFactory.getLog(BeanReferenceOverrider.class);
    private int order;
    private String originalBeanName;
    private String overridingBeanName;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanDefinitionNames.length; ++i) {
            String beanName = beanDefinitionNames[i];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            this.process(beanDefinition, beanName);
        }
    }

    protected void process(BeanDefinition beanDefinition, String beanPath) {
        final MutablePropertyValues properties = beanDefinition.getPropertyValues();
        PropertyValue[] propertyValues = properties.getPropertyValues();
        for (int i = 0; i < propertyValues.length; ++i) {
            final PropertyValue propertyValue = propertyValues[i];
            Object value = propertyValue.getValue();
            String propertyPath = beanPath + "." + propertyValue.getName();
            this.processValue(value, new ReferenceUpdater(){

                @Override
                public void updateReference(RuntimeBeanReference newRef) {
                    properties.addPropertyValue(propertyValue.getName(), (Object)newRef);
                }
            }, propertyPath);
        }
    }

    protected void processValue(Object value, ReferenceUpdater updater, String propertyPath) {
        block6: {
            block5: {
                if (value == null) {
                    return;
                }
                if (!(value instanceof BeanReference)) break block5;
                if (!((BeanReference)value).getBeanName().equals(this.getOriginalBeanName())) break block6;
                RuntimeBeanReference newRef = new RuntimeBeanReference(this.getOverridingBeanName());
                updater.updateReference(newRef);
                if (!log.isInfoEnabled()) break block6;
                log.info((Object)("Changed reference " + propertyPath + " from " + this.getOriginalBeanName() + " to " + this.getOverridingBeanName()));
                break block6;
            }
            if (value instanceof BeanDefinitionHolder) {
                BeanDefinition innerBeanDef = ((BeanDefinitionHolder)value).getBeanDefinition();
                this.process(innerBeanDef, propertyPath);
            } else if (value instanceof ManagedList) {
                ManagedList list = (ManagedList)value;
                final ListIterator it = list.listIterator();
                while (it.hasNext()) {
                    Object listValue = it.next();
                    String listPath = propertyPath + "[" + it.previousIndex() + "]";
                    this.processValue(listValue, new ReferenceUpdater(){

                        @Override
                        public void updateReference(RuntimeBeanReference newRef) {
                            it.set(newRef);
                        }
                    }, listPath);
                }
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getOriginalBeanName() {
        return this.originalBeanName;
    }

    public void setOriginalBeanName(String originalBeanName) {
        this.originalBeanName = originalBeanName;
    }

    public String getOverridingBeanName() {
        return this.overridingBeanName;
    }

    public void setOverridingBeanName(String overridingBeanName) {
        this.overridingBeanName = overridingBeanName;
    }

    protected static interface ReferenceUpdater {
        public void updateReference(RuntimeBeanReference var1);
    }
}

