/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.ProfileAttributeImpl;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.AttributesRemoteService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.utils.JAXBList;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="restProfileAttributeService")
public class RESTAttribute
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTAttribute.class);
    @Resource
    private AttributesRemoteService attributesRemoteService;

    public void setAttributesRemoteService(AttributesRemoteService attributesRemoteServiceImpl) {
        this.attributesRemoteService = attributesRemoteServiceImpl;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        this.restUtils.setStatusAndBody(200, resp, this.generateProfileAttributeReport(this.attributesRemoteService.getAttributesOfUser(this.restUtils.extractResourceName(req.getPathInfo()))));
    }

    private String generateProfileAttributeReport(List<ProfileAttribute> atts) {
        try {
            StringWriter sw = new StringWriter();
            JAXBList<ProfileAttribute> lst = new JAXBList<ProfileAttribute>(atts);
            Marshaller m = this.restUtils.getMarshaller(JAXBList.class, ProfileAttributeImpl.class);
            m.marshal(lst, (Writer)sw);
            if (log.isDebugEnabled()) {
                log.debug((Object)("finished marshaling attributes: " + lst.size()));
            }
            return sw.toString();
        }
        catch (JAXBException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        try {
            String userName = this.restUtils.getFullUserName(this.restUtils.extractResourceName(req.getPathInfo()));
            JAXBList atts = (JAXBList)this.restUtils.unmarshal((InputStream)req.getInputStream(), JAXBList.class, ProfileAttributeImpl.class);
            for (int i = 0; i < atts.size(); ++i) {
                this.attributesRemoteService.putAttribute(userName, (ProfileAttribute)atts.get(i));
            }
            this.restUtils.setStatusAndBody(201, resp, "");
        }
        catch (IOException e) {
            throw new ServiceException(500, e.getMessage());
        }
        catch (JAXBException e) {
            throw new ServiceException(500, e.getMessage());
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        this.doPut(req, resp);
    }
}

