/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class GETTest
extends RESTTest {
    private final Log log = LogFactory.getLog(this.getClass());
    private static ObjectMapper jsonMapper = new ObjectMapper();

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.httpReqCE = new HttpGet();
        this.httpReqPro = new HttpGet();
    }

    @Test
    public void testCeLoginUsingKeyStore() throws Exception {
        PublicKey publicKey = this.getPublicKey();
        String encryptedUtfCePass = this.getEncryptedPassword(publicKey, "jasperadmin");
        this.loginToServer("jasperadmin", encryptedUtfCePass, "jasperadmin%7Corganization_1", null);
        this.sendAndAssert_CE(this.httpReqCE, "/user/jasperadmin");
    }

    @Ignore
    @Test
    public void testLoginUsingKeyStoreWithForeignChars() throws Exception {
        String russianUserName = "\u0436\u0430\u0441\u043f\u0435\u0440\u0430\u0434\u043c\u0438\u043d";
        String russianPassword = "\u0436\u0430\u0441\u043f\u0435\u0440\u0430\u0434\u043c\u0438\u043d";
        PublicKey publicKey = this.getPublicKey();
        String encryptedUtfProPass = this.getEncryptedPassword(publicKey, russianPassword);
        this.loginToServer(null, null, russianUserName, encryptedUtfProPass);
        this.sendAndAssert_PRO(this.httpReqPro, "/user/" + russianUserName);
    }

    @Test
    public void testProLoginUsingKeyStore() throws Exception {
        PublicKey publicKey = this.getPublicKey();
        String encryptedUtfProPass = this.getEncryptedPassword(publicKey, "jasperadmin");
        this.loginToServer(null, null, "jasperadmin", encryptedUtfProPass);
        this.sendAndAssert_PRO(this.httpReqPro, "/user/jasperadmin");
    }

    @Test
    public void JobSummary_Get_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/jobsummary/reports/samples/AllAccounts");
        this.sendAndAssert_PRO(this.httpReqPro, "/jobsummary/reports/samples/AllAccounts");
    }

    @Test
    public void Job_Get_200() throws Exception {
        this.putSampleJob_CE();
        int ceJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_CE());
        this.sendAndAssert_CE(this.httpReqCE, "/job/" + ceJobIndex);
        this.deleteJob(ceJobIndex, false);
        this.putSampleJob_PRO();
        this.getSampleJobSummary_PRO();
        int proJobIndex = this.getJobIndexFromJobSummary(this.getSampleJobSummary_PRO());
        this.sendAndAssert_PRO(this.httpReqPro, "/job/" + proJobIndex);
        this.deleteJob(proJobIndex, true);
    }

    @Test
    public void User_Get_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/user/jasperadmin");
        this.sendAndAssert_PRO(this.httpReqPro, "/user/jasperadmin%7Corganization_1");
    }

    @Test
    public void Role_Get_200_PUBLIC_ROLES() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/role/ROLE_USER");
    }

    @Test
    public void Permission_Get_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/permission/reports");
        this.sendAndAssert_PRO(this.httpReqPro, "/permission/public");
    }

    @Test
    public void Attributes_Get_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/attribute/jasperadmin");
        this.sendAndAssert_PRO(this.httpReqPro, "/attribute/CaliforniaUser%7Corganization_1");
    }

    @Test
    public void Organization_Get_200() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/organization/organization_1");
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("includeSubTenants", "true"));
        HttpResponse res = this.sendRequestPRO(this.httpReqPro, "/organization/organization_1", params);
        Assert.assertTrue((String)"basic response check did not pass", (boolean)this.isValidResposnse(res, 200));
    }

    @Test
    public void Resources_Folder_GET_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resources/ContentFiles");
        this.sendAndAssert_PRO(this.httpReqPro, "/resources/");
    }

    @Test
    public void Resources_Type_Recursive_GET_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resources/?type=reportUnit&recursive=true");
        this.sendAndAssert_PRO(this.httpReqPro, "/resources/?type=reportUnit&recursive=true");
    }

    @Test
    public void Resource_Image_File_GET_200() throws Exception {
        this.putSampleFolderAndFile();
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("fileData", "true"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.isValidResposnse() && this.httpRes.getEntity().getContentLength() == 4788L ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER/JUNIT_IMAGE_FILE", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.isValidResposnse() && this.httpRes.getEntity().getContentLength() == 4788L ? 1 : 0) != 0);
        this.deleteSampleFolder();
    }

    @Test
    public void Resources_Report_GET_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resource/reports/samples/AllAccounts");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/reports/samples/AllAccounts");
    }

    @Test
    public void Resources_LocalResource_GET_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resource/reports/samples/AllAccounts_files/AllAccounts_Res2");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/reports/samples/AllAccounts_files/AllAccounts_Res2");
    }

    @Test
    public void Resources_LocalResource_BIN_GET_200() throws Exception {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("fileData", "true"));
        this.httpRes = this.sendRequestCE(this.httpReqCE, "/resource/reports/samples/AllAccounts_files/AllAccounts_Res2", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.httpRes.getEntity().getContentLength() == 5181L && this.isValidResposnse() ? 1 : 0) != 0);
        this.httpRes = this.sendRequestPRO(this.httpReqPro, "/resource/reports/samples/AllAccounts_files/AllAccounts_Res2", qparams);
        Assert.assertTrue((String)"wrong file size: ", (this.httpRes.getEntity().getContentLength() == 5181L && this.isValidResposnse() ? 1 : 0) != 0);
    }

    @Test
    public void Resources_InputControl_GET_200() throws Exception {
        this.putSampleInputControlInSampleFolder();
        this.sendAndAssert_CE(this.httpReqCE, "/resource/JUNIT_NEW_FOLDER/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/JUNIT_NEW_FOLDER/JUNIT_INPUT_CONTROL_CONTAINS_LOCAL_RESOURCE");
        this.deleteSampleInputControl();
        this.deleteSampleFolder();
    }

    @Test
    public void Resources_JRXML_GET_200() throws Exception {
        this.sendAndAssert_CE(this.httpReqCE, "/resource/reports/samples/AllAccounts_files/AllAccountsReport");
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/reports/samples/AllAccounts_files/AllAccountsReport");
    }

    @Test
    public void Resource_DomainDataSource_GET_200() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/Domains/Simple_Domain");
    }

    @Test
    public void Resource_Query_GET_200() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/supermart/Common/CustomerCityQuery");
    }

    @Test
    public void Resource_DomainTopic_GET_200() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/adhoc/topics/Simple_Domain_Topic");
    }

    @Test
    public void Resource_Dashboard_GET_200() throws Exception {
        this.sendAndAssert_PRO(this.httpReqPro, "/resource/supermart/SupermartDashboard30");
    }

    @Test
    public void testLoginWithDynamicKeyHappensOncePerRequest() throws Exception {
        PublicKey publicKey = this.getPublicKey();
        String jasperadminPasswd = this.getEncryptedPassword(publicKey, "jasperadmin");
        String joeuserPasswd = this.getEncryptedPassword(publicKey, "joeuser");
        String demoPasswd = this.getEncryptedPassword(publicKey, "demo");
        this.loginToServer(null, null, "jasperadmin", jasperadminPasswd);
        String httpResStatusLine = this.httpRes.getStatusLine().toString();
        Assert.assertTrue((String)"Login failed", (httpResStatusLine.indexOf("OK") >= 0 ? 1 : 0) != 0);
        this.loginToServer(null, null, "joeuser", joeuserPasswd);
        String httpResStatusLine2 = this.httpRes.getStatusLine().toString();
        Assert.assertFalse((String)"Logged in successfully 2, failure expected", (httpResStatusLine2.indexOf("OK") >= 0 ? 1 : 0) != 0);
        this.loginToServer(null, null, "demo", demoPasswd);
        String httpResStatusLine3 = this.httpRes.getStatusLine().toString();
        Assert.assertFalse((String)"Logged in successfully 3, failure expected", (httpResStatusLine3.indexOf("OK") >= 0 ? 1 : 0) != 0);
    }

    private static String byteArrayToHexString(byte[] byteArr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArr.length; ++i) {
            byte b = byteArr[i];
            int high = (b & 0xF0) >> 4;
            int low = b & 0xF;
            sb.append(Character.forDigit(high, 16));
            sb.append(Character.forDigit(low, 16));
        }
        return sb.toString();
    }

    private String getEncryptedPassword(PublicKey publicKey, String pwd) throws Exception {
        Cipher enc = Cipher.getInstance("RSA/NONE/NoPadding", (Provider)new BouncyCastleProvider());
        enc.init(1, publicKey);
        String utfPass = URLEncoder.encode(pwd, "UTF-8");
        byte[] encryptedUtfPass = enc.doFinal(utfPass.getBytes());
        return GETTest.byteArrayToHexString(encryptedUtfPass);
    }

    private PublicKey getPublicKey() throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        HttpResponse httpRes = this.sendRequestProFroNonRestService(this.httpReqPro, "/GetEncryptionKey", null);
        String entityStr = IOUtils.toString((InputStream)httpRes.getEntity().getContent());
        JSONObject jpk = new JSONObject(entityStr);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger(jpk.getString("n"), 16), new BigInteger(jpk.getString("e"), 16));
        return keyFactory.generatePublic(publicKeySpec);
    }
}

