/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;

public abstract class AbstractExporter
implements ReportExporter {
    @Override
    public String getFileName(String reportUnitURI) {
        return null;
    }

    @Override
    public Map exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {
        JRExporter exporter = this.createExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)output);
        if (exportParameters.get("PAGE") != null) {
            int pageIndex = Integer.parseInt((String)exportParameters.get("PAGE"));
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)(--pageIndex));
        }
        this.configureExporter(exporter, exportParameters);
        exporter.exportReport();
        return exporter.getParameters();
    }

    public abstract JRExporter createExporter() throws Exception;

    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
    }

    protected Object getSingleParameterValue(String parameterName, Map<String, Object> exportParameters) {
        Object result = null;
        if (exportParameters.get(parameterName) != null) {
            if (exportParameters.get(parameterName) instanceof String[]) {
                if (((String[])exportParameters.get(parameterName)).length > 0) {
                    result = ((String[])exportParameters.get(parameterName))[0];
                }
            } else {
                result = exportParameters.get(parameterName);
            }
        }
        return result;
    }
}

