/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.exporters.AbstractExporter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.biff.RowsExceededException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="remoteXlsExporter")
@Scope(value="prototype")
public class XlsExporter
extends AbstractExporter {
    public static final String ONE_PAGE_PER_SHEET = "onePagePerSheet";
    @Resource(name="xlsExportParameters")
    private XlsExportParametersBean exportParams;
    @Resource
    protected MessageSource messageSource;

    @Override
    public JRExporter createExporter() throws Exception {
        return new JExcelApiExporter();
    }

    @Override
    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
        if (this.exportParams != null) {
            if (this.exportParams.isOverrideReportHints()) {
                exporter.setParameter(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, (Object)Boolean.TRUE);
            }
            if (this.exportParams.getOnePagePerSheet() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)this.exportParams.getOnePagePerSheet());
            }
            if (exportParameters.get(ONE_PAGE_PER_SHEET) != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.valueOf(String.valueOf(this.getSingleParameterValue(ONE_PAGE_PER_SHEET, exportParameters))));
            }
            if (this.exportParams.getDetectCellType() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)this.exportParams.getDetectCellType());
            }
            if (this.exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)this.exportParams.getRemoveEmptySpaceBetweenRows());
            }
            if (this.exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)this.exportParams.getRemoveEmptySpaceBetweenColumns());
            }
            if (this.exportParams.getWhitePageBackground() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)this.exportParams.getWhitePageBackground());
            }
            if (this.exportParams.getIgnoreGraphics() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)this.exportParams.getIgnoreGraphics());
            }
            if (this.exportParams.getCollapseRowSpan() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)this.exportParams.getCollapseRowSpan());
            }
            if (this.exportParams.getIgnoreCellBorder() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)this.exportParams.getIgnoreCellBorder());
            }
            if (this.exportParams.getFontSizeFixEnabled() != null) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)this.exportParams.getFontSizeFixEnabled());
            }
            if (this.exportParams.getMaximumRowsPerSheet() != null) {
                exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)this.exportParams.getMaximumRowsPerSheet());
            }
            if (this.exportParams.getXlsFormatPatternsMap() != null && !this.exportParams.getXlsFormatPatternsMap().isEmpty()) {
                exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)this.exportParams.getXlsFormatPatternsMap());
            }
        }
        exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
    }

    @Override
    public Map exportReport(JasperPrint jasperPrint, OutputStream output, EngineService engineService, HashMap exportParameters, ExecutionContext executionContext, String reportUnitURI) throws Exception {
        try {
            return super.exportReport(jasperPrint, output, engineService, exportParameters, executionContext, reportUnitURI);
        }
        catch (Exception e) {
            if (e.getCause() instanceof RowsExceededException) {
                throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("jsexception.too.many.data.rows").setMessage(this.messageSource.getMessage("jsexception.too.many.data.rows", null, LocaleContextHolder.getLocale())).getErrorDescriptor());
            }
            throw e;
        }
    }

    public void setExportParams(XlsExportParametersBean exportParams) {
        this.exportParams = exportParams;
    }

    @Override
    public String getContentType() {
        return "application/xls";
    }
}

