/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.AbstractResourceHandler;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import com.jaspersoft.jasperserver.remote.handlers.ResourceContainer;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="reportUnitHandler")
public class ReportUnitHandler
extends RepositoryResourceHandler
implements ResourceContainer {
    private static final Log log = LogFactory.getLog(ReportUnitHandler.class);
    public static final String OPTION_REPORT_UNIT_CONTENTS = "ReportUnitContents";

    @Override
    public Class getResourceType() {
        return ReportUnit.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        Boolean reportUnitContent;
        ReportUnit reportUnit = (ReportUnit)resource;
        descriptor.setWsType("reportUnit");
        descriptor.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", reportUnit.isAlwaysPromptControls());
        descriptor.setResourceProperty("PROP_RU_CONTROLS_LAYOUT", (int)reportUnit.getControlsLayout());
        if (reportUnit.getInputControlRenderingView() != null) {
            descriptor.setResourceProperty("PROP_RU_INPUTCONTROL_RENDERING_VIEW", reportUnit.getInputControlRenderingView());
        }
        if (reportUnit.getReportRenderingView() != null) {
            descriptor.setResourceProperty("PROP_RU_REPORT_RENDERING_VIEW", reportUnit.getReportRenderingView());
        }
        Boolean bl = reportUnitContent = options == null ? null : (Boolean)options.get(OPTION_REPORT_UNIT_CONTENTS);
        if (reportUnitContent != null && reportUnitContent.booleanValue()) {
            List resources;
            List inputControls;
            ResourceReference ruQuery;
            ResourceReference ruDataSource = reportUnit.getDataSource();
            ResourcesManagementRemoteService resourcesManagementRemoteService = this.getResourcesManagementRemoteService();
            if (ruDataSource != null) {
                if (ruDataSource.isLocal()) {
                    ResourceDescriptor dsDescriptor = resourcesManagementRemoteService.createResourceDescriptor(ruDataSource.getLocalResource());
                    descriptor.getChildren().add(dsDescriptor);
                } else {
                    ResourceDescriptor rdDs = new ResourceDescriptor();
                    rdDs.setWsType("datasource");
                    rdDs.setReferenceUri(ruDataSource.getReferenceURI());
                    rdDs.setIsReference(true);
                    descriptor.getChildren().add(rdDs);
                }
            }
            if ((ruQuery = reportUnit.getQuery()) != null) {
                if (ruQuery.isLocal()) {
                    ResourceDescriptor queryDescriptor = resourcesManagementRemoteService.createResourceDescriptor(ruQuery.getLocalResource());
                    descriptor.getChildren().add(ruQuery);
                } else {
                    ResourceDescriptor rdDs = new ResourceDescriptor();
                    rdDs.setWsType("query");
                    rdDs.setReferenceUri(ruDataSource.getReferenceURI());
                    rdDs.setIsReference(true);
                    descriptor.getChildren().add(rdDs);
                }
            }
            ResourceReference ruMainReportResourceResourceReference = reportUnit.getMainReport();
            ResourceDescriptor ruMainReportResourceDescriptor = null;
            if (ruMainReportResourceResourceReference != null) {
                if (ruMainReportResourceResourceReference.isLocal()) {
                    ruMainReportResourceDescriptor = resourcesManagementRemoteService.createResourceDescriptor(ruMainReportResourceResourceReference.getLocalResource());
                } else {
                    ruMainReportResourceDescriptor = resourcesManagementRemoteService.createResourceDescriptor(resourcesManagementRemoteService.locateResource(ruMainReportResourceResourceReference.getReferenceURI()));
                    ruMainReportResourceDescriptor.setReferenceUri(ruMainReportResourceResourceReference.getReferenceURI());
                    ruMainReportResourceDescriptor.setIsReference(true);
                }
                ruMainReportResourceDescriptor.setMainReport(true);
                descriptor.getChildren().add(ruMainReportResourceDescriptor);
            }
            if ((inputControls = reportUnit.getInputControls()) != null && !inputControls.isEmpty()) {
                for (ResourceReference resRef : inputControls) {
                    ResourceDescriptor ruResourceDescriptor = null;
                    ruResourceDescriptor = resRef.isLocal() ? resourcesManagementRemoteService.createResourceDescriptor(resRef.getLocalResource()) : resourcesManagementRemoteService.createResourceDescriptor(resourcesManagementRemoteService.locateResource(resRef.getReferenceURI(), ExecutionContextImpl.getRuntimeExecutionContext()));
                    if (ruResourceDescriptor == null) continue;
                    descriptor.getChildren().add(ruResourceDescriptor);
                }
            }
            if ((resources = reportUnit.getResources()) != null && !resources.isEmpty()) {
                for (ResourceReference resRef : resources) {
                    ResourceDescriptor ruResourceDescriptor = null;
                    ruResourceDescriptor = resRef.isLocal() ? resourcesManagementRemoteService.createResourceDescriptor(resRef.getLocalResource()) : resourcesManagementRemoteService.createResourceDescriptor(resourcesManagementRemoteService.locateResource(resRef.getReferenceURI()));
                    if (ruResourceDescriptor == null || ruMainReportResourceDescriptor.getUriString().equals(ruResourceDescriptor.getUriString())) continue;
                    descriptor.getChildren().add(ruResourceDescriptor);
                }
            }
        }
    }

    @Override
    public void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        String renderingView;
        String controlsView;
        Integer controlsLayout;
        super.updateResource(resource, descriptor, options);
        ReportUnit reportUnit = (ReportUnit)resource;
        Boolean alwaysPrompt = descriptor.getResourcePropertyValueAsBoolean("PROP_RU_ALWAYS_PROPMT_CONTROLS");
        if (alwaysPrompt != null) {
            reportUnit.setAlwaysPromptControls(alwaysPrompt.booleanValue());
        }
        if ((controlsLayout = descriptor.getResourcePropertyValueAsInteger("PROP_RU_CONTROLS_LAYOUT")) != null) {
            reportUnit.setControlsLayout(controlsLayout.byteValue());
        }
        if ((controlsView = descriptor.getResourcePropertyValue("PROP_RU_INPUTCONTROL_RENDERING_VIEW")) != null) {
            reportUnit.setInputControlRenderingView(controlsView);
        }
        if ((renderingView = descriptor.getResourcePropertyValue("PROP_RU_REPORT_RENDERING_VIEW")) != null) {
            reportUnit.setReportRenderingView(renderingView);
        }
        List children = descriptor.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String referenceURI;
            ResourceDescriptor childResource = (ResourceDescriptor)children.get(i);
            if (this.isDataSource(childResource)) {
                if (childResource.getIsReference()) {
                    reportUnit.setDataSourceReference(childResource.getReferenceUri());
                    continue;
                }
                ReportDataSource dataSource = (ReportDataSource)this.createChildResource(childResource);
                reportUnit.setDataSource(dataSource);
                continue;
            }
            if (ResourceDescriptor.isFileType((String)childResource.getWsType()) || childResource.getWsType().equals("reference")) {
                if (childResource.isMainReport()) {
                    referenceURI = childResource.getReferenceUri();
                    if (referenceURI != null && referenceURI.trim().length() > 0) {
                        reportUnit.setMainReportReference(referenceURI);
                        continue;
                    }
                    FileResource fileResource = (FileResource)this.createChildResource(childResource);
                    fileResource.setFileType(childResource.getWsType());
                    reportUnit.setMainReport(fileResource);
                    continue;
                }
                FileResource fileResource = (FileResource)this.createChildResource(childResource);
                fileResource.setFileType(childResource.getWsType());
                reportUnit.addResource(fileResource);
                continue;
            }
            if (!childResource.getWsType().equals("inputControl")) continue;
            referenceURI = childResource.getReferenceUri();
            if (referenceURI != null && referenceURI.trim().length() > 0) {
                reportUnit.addInputControlReference(referenceURI);
                continue;
            }
            InputControl ic = (InputControl)this.createChildResource(childResource);
            reportUnit.addInputControl(ic);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource addSubResource(Resource parent, ResourceDescriptor descriptor) throws ServiceException {
        ReportUnit reportUnit = (ReportUnit)parent;
        ReportDataSource subResource = null;
        if (descriptor.getIsNew()) {
            String wsType = descriptor.getWsType();
            if (this.isDataSource(descriptor)) {
                ReportDataSource dataSource = (ReportDataSource)this.createChildResource(descriptor);
                reportUnit.setDataSource(dataSource);
                return dataSource;
            }
            if (wsType.equals("query")) {
                Query queryResource = (Query)this.createChildResource(descriptor);
                reportUnit.setQuery(new ResourceReference((Resource)queryResource));
                return queryResource;
            }
            if (wsType.equals("olapXmlaCon")) {
                XMLAConnection datasource = (XMLAConnection)this.createChildResource(descriptor);
                reportUnit.setDataSource((ReportDataSource)datasource);
                return datasource;
            }
            if (wsType.equals("reference") || wsType.equals("img") || wsType.equals("font") || wsType.equals("jar") || wsType.equals("jrxml") || wsType.equals("prop") || wsType.equals("jrtx")) {
                FileResource fileResource = (FileResource)this.createChildResource(descriptor);
                reportUnit.addResource(fileResource);
                return fileResource;
            }
            if (!wsType.equals("inputControl")) throw new ServiceException(6, this.getMessageSource().getMessage("webservices.error.generic.not.supported", new Object[0], LocaleContextHolder.getLocale()));
            if (descriptor.getIsReference()) {
                String referenceUri = descriptor.getReferenceUri();
                log.info((Object)("Adding control to RU: " + referenceUri));
                InputControl inputControl = (InputControl)this.getRepository().getResource(null, referenceUri, InputControl.class);
                if (inputControl == null) {
                    throw new ServiceException(404, this.getMessageSource().getMessage("webservices.error.resourceNotFoundOrInvalid", new Object[]{referenceUri}, LocaleContextHolder.getLocale()));
                }
                reportUnit.addInputControlReference(referenceUri);
                return inputControl;
            }
            InputControl inputControl = (InputControl)this.createChildResource(descriptor);
            reportUnit.addInputControl(inputControl);
            return inputControl;
        }
        Resource resource = this.getReportUnitResource(descriptor, reportUnit);
        if (resource == null) {
            throw new ServiceException(2, "webservices.error.resourceNotFound");
        }
        ResourceHandler handler = this.getResourcesManagementRemoteService().getHandler(resource);
        if (handler instanceof AbstractResourceHandler) {
            ((AbstractResourceHandler)handler).updateResource(resource, descriptor, null);
        }
        if (!descriptor.isMainReport()) return resource;
        if (!reportUnit.getMainReport().isLocal()) return resource;
        reportUnit.setMainReport((FileResource)resource);
        return resource;
    }

    private Resource getReportUnitResource(ResourceDescriptor descriptor, ReportUnit reportUnit) {
        Resource resource = null;
        if (descriptor.isMainReport()) {
            ResourceReference resRef = reportUnit.getMainReport();
            Resource jrxmlResource = null;
            jrxmlResource = resRef.isLocal() ? resRef.getLocalResource() : this.getRepository().getResource(null, resRef.getReferenceURI());
            resource = jrxmlResource;
        } else {
            List resources = reportUnit.getResources();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                Resource genericResource = null;
                genericResource = resRef.isLocal() ? resRef.getLocalResource() : this.getRepository().getResource(null, resRef.getReferenceURI());
                if (!genericResource.getURIString().equals(descriptor.getUriString())) continue;
                resource = genericResource;
                break;
            }
        }
        return resource;
    }

    @Override
    public void deleteSubResource(Resource parent, ResourceDescriptor childDescriptor) throws ServiceException {
        ReportUnit reportUnit = (ReportUnit)parent;
        if (childDescriptor.isMainReport()) {
            throw new ServiceException(2, this.getMessageSource().getMessage("webservices.error.deletingMainJrxml", new Object[0], LocaleContextHolder.getLocale()));
        }
        if (this.isMainQuery(childDescriptor)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Delete: removed ReportUnit query");
            }
            reportUnit.setQuery((ResourceReference)null);
        }
        if (this.isDataSource(childDescriptor) && reportUnit.getDataSource().getTargetURI() != null && reportUnit.getDataSource().getTargetURI().equals(childDescriptor.getUriString())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Delete: removed ReportUnit datasource");
            }
            reportUnit.setDataSource((ResourceReference)null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete: resource in reportUnit: " + childDescriptor.getWsType()));
        }
        if (childDescriptor.getWsType().equals("inputControl")) {
            List resources = reportUnit.getInputControls();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                if (resRef.isLocal() && childDescriptor.getName().equals(resRef.getLocalResource().getName())) {
                    reportUnit.removeInputControl(i);
                } else {
                    if (resRef.isLocal() || !childDescriptor.getUriString().equals(resRef.getReferenceURI())) continue;
                    reportUnit.removeInputControl(i);
                }
                break;
            }
        } else {
            List resources = reportUnit.getResources();
            for (int i = 0; i < resources.size(); ++i) {
                ResourceReference resRef = (ResourceReference)resources.get(i);
                if (resRef.isLocal() && childDescriptor.getName().equals(resRef.getLocalResource().getName())) {
                    reportUnit.removeResourceLocal(resRef.getLocalResource().getName());
                } else {
                    if (resRef.isLocal() || !childDescriptor.getUriString().equals(resRef.getReferenceURI())) continue;
                    reportUnit.removeResourceReference(childDescriptor.getUriString());
                }
                break;
            }
        }
    }

    public boolean isMainQuery(ResourceDescriptor descriptor) {
        String s = descriptor.getResourcePropertyValue("PROP_RU_IS_MAIN_QUERY");
        if (s != null) {
            return s.equals("true");
        }
        return false;
    }
}

