/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesConfiguration;
import com.jaspersoft.jasperserver.remote.services.ResourcesListRemoteService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.search.filter.FolderFilter;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.impl.RepositorySearchCriteriaImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="resourcesListRemoteService")
public class ResourcesListRemoteServiceImpl
implements ResourcesListRemoteService {
    private static final Log log = LogFactory.getLog(ResourcesListRemoteServiceImpl.class);
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;
    @Resource(name="concreteRepository")
    private RepositoryService repository;
    @Resource(name="remoteServiceConfiguration")
    private ServicesConfiguration servicesConfiguration;
    @Resource
    private RepositorySearchService repositorySearchService;
    @Resource
    private FolderFilter folderFilter;

    @Override
    public List listResources(String uri) throws ServiceException {
        return this.listResources(uri, 0);
    }

    @Override
    public List<ResourceDescriptor> listResources(String uri, int maxItems) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("list for uri: " + uri));
            log.debug((Object)("Max items: " + maxItems));
        }
        List<Object> listOfResources = new ArrayList<ResourceDescriptor>();
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.resourcesManagementRemoteService.locateResource(uri);
        if (resource == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No resource " + uri + " found"));
            }
            throw new ServiceException(404, "Invalid uri or not existing resource");
        }
        if (resource instanceof Folder) {
            List folders = this.repository.getSubFolders(null, uri);
            this.filterFolderList(folders);
            if (folders == null) {
                return listOfResources;
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("NO_ATTACHMENT", Boolean.TRUE);
            for (int i = 0; i < folders.size(); ++i) {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource folderRes = (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)folders.get(i);
                listOfResources.add(this.resourcesManagementRemoteService.createResourceDescriptor(folderRes));
            }
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
            List units = this.repository.loadClientResources(filterCriteria);
            if (units != null) {
                Iterator it = units.iterator();
                while (units != null && it.hasNext()) {
                    com.jaspersoft.jasperserver.api.metadata.common.domain.Resource fileRes = (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)it.next();
                    try {
                        listOfResources.add(this.resourcesManagementRemoteService.createResourceDescriptor(fileRes, options));
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                }
            }
        } else if (resource instanceof ReportUnit) {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("ReportUnitContents", Boolean.TRUE);
            listOfResources = this.resourcesManagementRemoteService.createResourceDescriptor(this.resourcesManagementRemoteService.locateResource(uri)).getChildren();
        }
        if (maxItems > 0 && maxItems < listOfResources.size()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There are " + listOfResources.size() + " found. Getting indexes from 0 to " + maxItems));
            }
            listOfResources = listOfResources.subList(0, maxItems);
        }
        return listOfResources;
    }

    @Override
    public List<ResourceDescriptor> getResources(FilterCriteria criteria, int maxItems, List<String> wsTypes) throws ServiceException {
        ArrayList<ResourceDescriptor> listOfResources = new ArrayList<ResourceDescriptor>();
        if (criteria == null) {
            return listOfResources;
        }
        List lookups = this.repository.loadClientResources(criteria);
        if (lookups != null && !lookups.isEmpty()) {
            for (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource currentResource : lookups) {
                ResourceDescriptor rd = this.resourcesManagementRemoteService.createResourceDescriptor(currentResource);
                if (wsTypes != null && !wsTypes.contains(rd.getWsType())) continue;
                listOfResources.add(rd);
                if (maxItems <= 0 || listOfResources.size() != maxItems) continue;
                break;
            }
        }
        return listOfResources;
    }

    protected List<ResourceDescriptor> convertToResourceDescriptors(List<com.jaspersoft.jasperserver.api.metadata.common.domain.Resource> resources) {
        ArrayList<ResourceDescriptor> result = null;
        if (resources != null && !resources.isEmpty()) {
            result = new ArrayList<ResourceDescriptor>();
            for (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource currentResource : resources) {
                ResourceDescriptor resourceDescriptor = this.resourcesManagementRemoteService.createResourceDescriptor(currentResource);
                if (resourceDescriptor == null) continue;
                result.add(resourceDescriptor);
            }
        }
        return result;
    }

    @Override
    public List getResources(String uri, String queryString, List<String> wsTypes, boolean recursive, int maxItems, int startIndex) throws ServiceException {
        RepositorySearchCriteria repositorySearchCriteria = new RepositorySearchCriteriaImpl.Builder().setFolderUri(uri).setSearchText(queryString).setStartIndex(startIndex).setMaxCount(maxItems).setSearchMode(SearchMode.SEARCH).setSortBy("name").getCriteria();
        this.fillCriteriaByHandlers(uri, queryString, wsTypes, recursive, maxItems, startIndex, repositorySearchCriteria);
        if (uri != null) {
            repositorySearchCriteria.addCustomFilter((SearchFilter)this.folderFilter);
        }
        List results = this.repositorySearchService.getResults(ExecutionContextImpl.getRuntimeExecutionContext(), repositorySearchCriteria);
        return this.convertToResourceDescriptors(results);
    }

    protected void fillCriteriaByHandlers(String uri, String queryString, List<String> wsTypes, boolean recursive, int maxItems, int startIndex, RepositorySearchCriteria repositorySearchCriteria) {
        if (wsTypes != null && !wsTypes.isEmpty()) {
            ArrayList<String> resourceTypes = repositorySearchCriteria.getResourceTypes();
            if (resourceTypes == null) {
                resourceTypes = new ArrayList<String>();
                repositorySearchCriteria.setResourceTypes(resourceTypes);
            }
            for (String currentWsType : wsTypes) {
                ResourceHandler resHandler = this.resourcesManagementRemoteService.getHandler(currentWsType);
                if (resHandler == null) {
                    throw new ServiceException(400, "Invalid resource type: " + currentWsType);
                }
                resourceTypes.add(resHandler.getResourceType().getName());
                SearchFilter customSearchFilter = resHandler.getSearchFilter(uri, queryString, currentWsType, recursive, maxItems, startIndex);
                if (customSearchFilter == null) continue;
                repositorySearchCriteria.addCustomFilter(customSearchFilter);
            }
        }
    }

    private void filterFolderList(List folderList) {
        if (folderList == null || folderList.isEmpty()) {
            return;
        }
        Set<String> roles = this.getCurrentUserRoles();
        Iterator i = folderList.iterator();
        while (i.hasNext()) {
            Folder folder = (Folder)i.next();
            if (!this.servicesConfiguration.getTempFolder().equals(folder.getURIString())) continue;
            boolean accessDenied = true;
            if (roles != null && roles.size() > 0) {
                for (String role : roles) {
                    if (!this.servicesConfiguration.getRoleToAccessTempFolder().equals(role)) continue;
                    accessDenied = false;
                    break;
                }
            }
            if (!accessDenied) continue;
            i.remove();
        }
    }

    private Set<String> getCurrentUserRoles() {
        HashSet<String> roleNames = new HashSet<String>();
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return roleNames;
        }
        if (authenticationToken.getPrincipal() instanceof UserDetails) {
            UserDetails contextUserDetails = (UserDetails)authenticationToken.getPrincipal();
            for (GrantedAuthority authority : contextUserDetails.getAuthorities()) {
                roleNames.add(authority.getAuthority());
            }
        }
        return roleNames;
    }
}

