/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.remote.common.ServerInfo;
import com.jaspersoft.jasperserver.remote.services.ServerInfoService;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component(value="serverInfoService")
public class ServerInfoServiceImpl
implements ServerInfoService {
    private static final String JS_VERSION = "JS_VERSION";
    private static final String OS_BUILD_DATE_STAMP = "OS_BUILD_DATE_STAMP";
    private static final String OS_BUILD_TIME_STAMP = "OS_BUILD_TIME_STAMP";
    @Resource
    protected MessageSource messageSource;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public ServerInfo getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setVersion(this.getServerVersion());
        serverInfo.setBuild(this.getServerBuild());
        serverInfo.setEdition(this.getServerEdition());
        return serverInfo;
    }

    protected ServerInfo.ServerEdition getServerEdition() {
        return ServerInfo.ServerEdition.CE;
    }

    protected String getMessageVersionId() {
        return JS_VERSION;
    }

    private String getServerVersion() {
        return this.messageSource.getMessage(this.getMessageVersionId(), new Object[0], Locale.getDefault());
    }

    private String getServerBuild() {
        return this.messageSource.getMessage(OS_BUILD_DATE_STAMP, new Object[0], Locale.getDefault()) + "_" + this.messageSource.getMessage(OS_BUILD_TIME_STAMP, new Object[0], Locale.getDefault());
    }
}

