/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.RoleImpl;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.remote.common.RoleSearchCriteria;
import com.jaspersoft.jasperserver.remote.common.UserSearchCriteria;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.UserAndRoleService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="userAndRoleService")
public class UserAndRoleServiceImpl
implements UserAndRoleService {
    @Resource(name="concreteSecurityContextProvider")
    private SecurityContextProvider securityContextProvider;
    @Resource(name="concreteTenantService")
    private TenantService tenantService;
    @Resource(name="concreteUserAuthorityService")
    protected UserAuthorityService userAuthorityService;
    @Resource(name="concreteAuditContext")
    private AuditContext auditContext;
    @Resource(name="configurationBean")
    private ConfigurationBean conf;
    @Resource
    private List<Role> defaultRoles;

    protected void createAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                UserAndRoleServiceImpl.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    protected void addExceptionToAuditEvent(String auditEventType, final Exception exception) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                UserAndRoleServiceImpl.this.auditContext.addPropertyToAuditEvent("exception", (Object)exception, auditEvent);
            }
        });
    }

    @Override
    public List<User> findUsers(UserSearchCriteria criteria) throws RemoteException {
        if (criteria == null || criteria.getTenantId() == null && criteria.getName() == null) {
            throw new IllegalStateException("findUser: malformed search criteria");
        }
        if (criteria.getTenantId() != null && !this.doesContextUserHasAccessToTenant(criteria.getTenantId())) {
            throw new RemoteException("Access is denied: the current logged user can not access the requested information");
        }
        ArrayList userList = new ArrayList();
        int maxRecords = criteria.getMaxRecords();
        Boolean includeSubOrgs = criteria.getIncludeSubOrgs();
        Set tenantsCriteriaSet = this.getTenantsCriteriaSet(criteria.getTenantId(), includeSubOrgs == null || includeSubOrgs != false);
        List result = maxRecords > 0 ? this.userAuthorityService.getTenantUsers(null, tenantsCriteriaSet, criteria.getName(), 0, maxRecords) : this.userAuthorityService.getTenantUsers(null, tenantsCriteriaSet, criteria.getName());
        return this.getUsersWithRoles(result, criteria.getRequiredRoles());
    }

    @Override
    public User putUser(User user) throws RemoteException {
        String auditEventType = "createUser";
        try {
            if (user == null) {
                this.createAuditEvent(auditEventType);
                throw new RemoteException("User is null.");
            }
            String nameWithoutNotSupportedSymbols = user.getUsername().replaceAll(this.conf.getUserNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != user.getUsername().length()) {
                this.createAuditEvent(auditEventType);
                throw new RemoteException("User name contains not supported symbols");
            }
            User existedUser = this.getUser(user);
            auditEventType = existedUser == null ? "createUser" : "updateUser";
            this.createAuditEvent(auditEventType);
            if (!this.isEmailValid(user)) {
                throw new RemoteException("Email address contains not supported symbols");
            }
            if (user.getPassword() == null || user.getPassword().trim().length() == 0) {
                throw new RemoteException("Password should not be empty");
            }
            if (!this.doesContextUserHasAccessToTenant(user.getTenantId())) {
                throw new RemoteException("Access is denied.");
            }
            if (existedUser == null && this.defaultRoles != null) {
                for (Role role : this.defaultRoles) {
                    this.addDefaultRoleToUser(role, user);
                }
            }
            try {
                this.userAuthorityService.putUser(null, user);
            }
            catch (Exception e) {
                this.handleUnexpectedException(e, user.getUsername());
            }
            return user;
        }
        catch (RemoteException remoteException) {
            this.addExceptionToAuditEvent(auditEventType, remoteException);
            throw remoteException;
        }
    }

    @Override
    public void deleteUser(User user) throws RemoteException {
        this.createAuditEvent("deleteUser");
        try {
            if (user == null) {
                throw new RemoteException("User is null.");
            }
            if (!this.doesContextUserHasAccessToTenant(user.getTenantId())) {
                throw new RemoteException("Access is denied.");
            }
            this.deleteUser(user.getUsername(), user.getTenantId());
        }
        catch (RemoteException remoteException) {
            this.addExceptionToAuditEvent("deleteUser", remoteException);
            throw remoteException;
        }
    }

    @Override
    public List<Role> findRoles(RoleSearchCriteria criteria) throws RemoteException {
        if (criteria == null) {
            throw new RemoteException("Role search criteria is null.");
        }
        if (!this.doesContextUserHasAccessToTenant(criteria.getTenantId()) && !this.isRootTenant(criteria.getTenantId())) {
            throw new RemoteException("Access is denied.");
        }
        int maxRecords = criteria.getMaxRecords();
        Boolean includeSubOrgs = criteria.getIncludeSubOrgs();
        Set tenantsCriteriaSet = this.getTenantsCriteriaSet(criteria.getTenantId(), includeSubOrgs == null || includeSubOrgs != false);
        List result = maxRecords > 0 ? this.userAuthorityService.getTenantRoles(null, tenantsCriteriaSet, criteria.getRoleName(), 0, maxRecords) : this.userAuthorityService.getTenantRoles(null, tenantsCriteriaSet, criteria.getRoleName());
        return result;
    }

    @Override
    public Role putRole(Role role) throws RemoteException {
        if (this.isValidRole(role)) {
            String auditEventType = "createRole";
            try {
                if (role == null) {
                    this.createAuditEvent(auditEventType);
                    throw new RemoteException("Role is null.");
                }
                String nameWithoutNotSupportedSymbols = role.getRoleName().replaceAll(this.conf.getRoleNameNotSupportedSymbols(), "");
                if (nameWithoutNotSupportedSymbols.length() != role.getRoleName().length()) {
                    this.createAuditEvent(auditEventType);
                    throw new RemoteException("Role name contains not supported symbols");
                }
                Role existedRole = this.getRole(role);
                auditEventType = existedRole == null ? "createRole" : "updateRole";
                this.createAuditEvent(auditEventType);
                if (!this.doesContextUserHasAccessToTenant(role.getTenantId())) {
                    throw new RemoteException("Access is denied.");
                }
                this.userAuthorityService.putRole(null, role);
                Role r = this.getRole(role);
                if (r != null) {
                    return r;
                }
                throw new RemoteException("Error while putting role : " + role.getRoleName());
            }
            catch (RemoteException remoteException) {
                this.addExceptionToAuditEvent(auditEventType, remoteException);
                throw remoteException;
            }
        }
        throw new IllegalArgumentException("illegal role attributes");
    }

    @Override
    public Role updateRoleName(Role oldRole, String newName) throws RemoteException {
        this.createAuditEvent("updateRole");
        try {
            if (oldRole == null) {
                throw new RemoteException("Role is null.");
            }
            if (newName == null) {
                throw new RemoteException("New name is null.");
            }
            Role aRole = oldRole;
            String nameWithoutNotSupportedSymbols = newName.replaceAll(this.conf.getRoleNameNotSupportedSymbols(), "");
            if (nameWithoutNotSupportedSymbols.length() != newName.length()) {
                throw new RemoteException("Role name contains not supported symbols");
            }
            if (!this.doesContextUserHasAccessToTenant(aRole.getTenantId())) {
                throw new RemoteException("Access is denied.");
            }
            Role existedRole = this.getRole(aRole);
            if (existedRole == null) {
                throw new RemoteException("Can't find role " + aRole.getRoleName());
            }
            String auditEventType = "updateRole";
            this.createAuditEvent(auditEventType);
            RoleImpl newRole = new RoleImpl();
            newRole.setRoleName(newName);
            newRole.setTenantId(existedRole.getTenantId());
            newRole.setExternallyDefined(existedRole.isExternallyDefined());
            Role r = this.updateRole(existedRole, (Role)newRole);
            if (r != null) {
                return r;
            }
            throw new RemoteException("Error while putting role : " + aRole.getRoleName());
        }
        catch (RemoteException remoteException) {
            this.addExceptionToAuditEvent("updateRole", remoteException);
            throw remoteException;
        }
    }

    @Override
    public void deleteRole(Role role) throws RemoteException {
        this.createAuditEvent("deleteRole");
        try {
            if (role == null) {
                throw new RemoteException("Role is null.");
            }
            if (!this.doesContextUserHasAccessToTenant(role.getTenantId())) {
                throw new RemoteException("Access is denied.");
            }
            this.deleteRole(role.getRoleName(), role.getTenantId());
        }
        catch (RemoteException remoteException) {
            this.addExceptionToAuditEvent("deleteRole", remoteException);
            throw remoteException;
        }
    }

    private boolean isValidRole(Role role) {
        return role.getRoleName() != null && !role.getRoleName().equals("") && role.getRoleName().replaceAll(this.conf.getRoleNameNotSupportedSymbols(), "").equals(role.getRoleName());
    }

    private boolean isRootTenant(String tenantId) throws RemoteException {
        return tenantId == null || "organizations".equals(tenantId);
    }

    private boolean isEmailValid(User user) throws RemoteException {
        String email = user.getEmailAddress();
        if (email == null) {
            return true;
        }
        return !(email.trim().length() > 0 ? !JasperServerUtil.regExValidateEmail((String)user.getEmailAddress()) : email.trim().length() != email.length());
    }

    protected Role updateRole(Role oldRole, Role newRole) {
        this.userAuthorityService.updateRole(null, oldRole.getRoleName(), newRole);
        return this.getRole(newRole);
    }

    private void addDefaultRoleToUser(Role role, User user) {
        if (role == null) {
            return;
        }
        boolean isUserHasRole = false;
        for (Object o : user.getRoles()) {
            Role r = (Role)o;
            boolean isNameEquals = role.getRoleName().equals(r.getRoleName());
            boolean isTenantEquals = this.isTenantEquals(role.getTenantId(), r.getTenantId());
            isUserHasRole = isNameEquals && isTenantEquals;
            if (!isUserHasRole) continue;
            return;
        }
        user.addRole(role);
    }

    protected void deleteRole(String roleName, String tenantId) {
        this.userAuthorityService.deleteRole(null, roleName);
    }

    private List<User> getUsersWithRoles(List users, List<Role> roles) {
        if (roles == null) {
            return new ArrayList<User>(users);
        }
        ArrayList<User> userList = new ArrayList<User>();
        for (Object o : users) {
            User u = (User)o;
            if (!this.isUserHasRoles(u, roles)) continue;
            userList.add(u);
        }
        return userList;
    }

    private boolean isUserHasRoles(User user, List<Role> roles) {
        boolean isUserHasRoles = true;
        for (Role r : roles) {
            boolean hasRole = false;
            for (Object o : user.getRoles()) {
                Role ur = (Role)o;
                boolean isNameEquals = ur.getRoleName().equals(r.getRoleName());
                boolean isTenantEquals = this.isTenantEquals(ur.getTenantId(), r.getTenantId());
                if (!isNameEquals || !isTenantEquals) continue;
                hasRole = true;
                break;
            }
            if (hasRole) continue;
            isUserHasRoles = false;
            break;
        }
        return isUserHasRoles;
    }

    private boolean isTenantEquals(String tenantId1, String tenantId2) {
        if (tenantId1 == null) {
            return tenantId2 == null;
        }
        return tenantId1.equals(tenantId2);
    }

    protected Set getTenantsCriteriaSet(String tenantId, boolean includeSubOrgs) throws RemoteException {
        HashSet<String> tenantIdSet = new HashSet<String>();
        tenantIdSet.add(tenantId);
        if (includeSubOrgs) {
            String id = tenantId == null ? "organizations" : tenantId;
            List allTenants = null;
            try {
                allTenants = this.tenantService.getAllSubTenantList(null, id);
            }
            catch (Exception e) {
                throw new RemoteException("Organization '" + tenantId + "' not found.");
            }
            if (allTenants != null) {
                for (Tenant tenant : allTenants) {
                    tenantIdSet.add(tenant.getId());
                }
            }
        }
        return tenantIdSet;
    }

    protected Role getRole(Role role) {
        return this.userAuthorityService.getRole(null, role.getRoleName());
    }

    protected void deleteUser(String username, String tenantId) {
        this.userAuthorityService.deleteUser(null, username);
    }

    protected User getUser(User user) {
        return this.userAuthorityService.getUser(null, user.getUsername());
    }

    protected void handleUnexpectedException(Exception unexpectedException, String username) throws RemoteException {
        throw new RemoteException("An unexpected exception has occurred while putting user:" + username);
    }

    private boolean doesContextUserHasAccessToTenant(String tenantId) throws RemoteException {
        String currentTenantId = this.securityContextProvider.getContextUser().getTenantId();
        Set tenants = this.getTenantsCriteriaSet(currentTenantId, true);
        return tenants.contains(tenantId);
    }

    public void setDefaultRoles(List<Role> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public void setConf(ConfigurationBean conf) {
        this.conf = conf;
    }
}

