/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(DDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues = new HashSet<String>();

    public static String getTypeName(int token) throws SemanticException {
        if (token == 77 || token == 78) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        return TokenToTypeName.get(token);
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 96: {
                ASTNode tablePart = (ASTNode)ast.getChild(0);
                TablePartition tblPart = new TablePartition(tablePart);
                String tableName = tblPart.tableName;
                HashMap<String, String> partSpec = tblPart.partSpec;
                ast = (ASTNode)ast.getChild(1);
                if (ast.getToken().getType() == 111) {
                    this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 104) {
                    this.analyzeAlterTableProtectMode(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 112) {
                    this.analyzeAlterTableLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 230) {
                    this.analyzeAlterTablePartMergeFiles(tablePart, ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 109) {
                    this.analyzeAlterTableSerde(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 108) {
                    this.analyzeAlterTableSerdeProps(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() != 100) break;
                this.analyzeAlterTableRenamePart(ast, tableName, partSpec);
                break;
            }
            case 128: {
                this.analyzeDropTable(ast, false);
                break;
            }
            case 89: {
                this.analyzeCreateIndex(ast);
                break;
            }
            case 92: {
                this.analyzeDropIndex(ast);
                break;
            }
            case 94: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescribeTable(ast);
                break;
            }
            case 118: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowDatabases(ast);
                break;
            }
            case 119: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTables(ast);
                break;
            }
            case 122: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowTableStatus(ast);
                break;
            }
            case 120: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowFunctions(ast);
                break;
            }
            case 123: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowLocks(ast);
                break;
            }
            case 95: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescFunction(ast);
                break;
            }
            case 225: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeDescDatabase(ast);
                break;
            }
            case 117: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeMetastoreCheck(ast);
                break;
            }
            case 165: {
                this.analyzeDropTable(ast, true);
                break;
            }
            case 166: {
                this.analyzeAlterTableProps(ast, true);
                break;
            }
            case 167: {
                this.analyzeAlterTableAddParts((ASTNode)ast.getChild(0), true);
                break;
            }
            case 168: {
                this.analyzeAlterTableDropParts((ASTNode)ast.getChild(0), true);
                break;
            }
            case 169: {
                this.analyzeAlterTableRename((ASTNode)ast.getChild(0), true);
                break;
            }
            case 97: {
                this.analyzeAlterTableRename(ast, false);
                break;
            }
            case 105: {
                this.analyzeAlterTableTouch(ast);
                break;
            }
            case 106: {
                this.analyzeAlterTableArchive(ast, false);
                break;
            }
            case 107: {
                this.analyzeAlterTableArchive(ast, true);
                break;
            }
            case 98: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.ADDCOLS);
                break;
            }
            case 101: {
                this.analyzeAlterTableModifyCols(ast, AlterTableDesc.AlterTableTypes.REPLACECOLS);
                break;
            }
            case 99: {
                this.analyzeAlterTableRenameCol(ast);
                break;
            }
            case 102: {
                this.analyzeAlterTableAddParts(ast, false);
                break;
            }
            case 103: {
                this.analyzeAlterTableDropParts(ast, false);
                break;
            }
            case 113: {
                this.analyzeAlterTableProps(ast, false);
                break;
            }
            case 151: {
                this.analyzeAlterTableClusterSort(ast);
                break;
            }
            case 115: {
                this.analyzeAlterIndexRebuild(ast);
                break;
            }
            case 116: {
                this.analyzeAlterIndexProps(ast);
                break;
            }
            case 121: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowPartitions(ast);
                break;
            }
            case 223: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowIndexes(ast);
                break;
            }
            case 124: {
                this.analyzeLockTable(ast);
                break;
            }
            case 125: {
                this.analyzeUnlockTable(ast);
                break;
            }
            case 87: {
                this.analyzeCreateDatabase(ast);
                break;
            }
            case 127: {
                this.analyzeDropDatabase(ast);
                break;
            }
            case 126: {
                this.analyzeSwitchDatabase(ast);
                break;
            }
            case 229: {
                this.analyzeAlterDatabase(ast);
                break;
            }
            case 197: {
                this.analyzeCreateRole(ast);
                break;
            }
            case 198: {
                this.analyzeDropRole(ast);
                break;
            }
            case 222: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowRoleGrant(ast);
                break;
            }
            case 220: {
                this.analyzeGrantRevokeRole(true, ast);
                break;
            }
            case 221: {
                this.analyzeGrantRevokeRole(false, ast);
                break;
            }
            case 199: {
                this.analyzeGrant(ast);
                break;
            }
            case 201: {
                this.ctx.setResFile(new Path(this.ctx.getLocalTmpFileURI()));
                this.analyzeShowGrant(ast);
                break;
            }
            case 200: {
                this.analyzeRevoke(ast);
                break;
            }
            default: {
                throw new SemanticException("Unsupported command.");
            }
        }
    }

    private void analyzeGrantRevokeRole(boolean grant, ASTNode ast) {
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(0));
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 1; i < ast.getChildCount(); ++i) {
            roles.add(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(i).getText()));
        }
        String roleOwnerName = "";
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            roleOwnerName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantRevokeRoleDDL grantRevokeRoleDDL = new GrantRevokeRoleDDL(grant, roles, principalDesc, roleOwnerName, PrincipalType.USER, true);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantRevokeRoleDDL), this.conf, new Task[0]));
    }

    private void analyzeShowGrant(ASTNode ast) throws SemanticException {
        ASTNode child;
        PrivilegeObjectDesc privHiveObj = null;
        ASTNode principal = (ASTNode)ast.getChild(0);
        PrincipalType type = PrincipalType.USER;
        switch (principal.getType()) {
            case 205: {
                type = PrincipalType.USER;
                break;
            }
            case 206: {
                type = PrincipalType.GROUP;
                break;
            }
            case 207: {
                type = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(principal.getChild(0).getText());
        PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
        List<String> cols = null;
        if (ast.getChildCount() > 1 && (child = (ASTNode)ast.getChild(1)).getToken().getType() == 219) {
            privHiveObj = new PrivilegeObjectDesc();
            privHiveObj.setObject(DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText()));
            if (child.getChildCount() > 1) {
                for (int i = 1; i < child.getChildCount(); ++i) {
                    ASTNode grandChild = (ASTNode)child.getChild(i);
                    if (grandChild.getToken().getType() == 11) {
                        privHiveObj.setPartSpec(DDLSemanticAnalyzer.getPartSpec(grandChild));
                        continue;
                    }
                    if (grandChild.getToken().getType() == 152) {
                        cols = this.getColumnNames(grandChild);
                        continue;
                    }
                    privHiveObj.setTable(child.getChild(i) != null);
                }
            }
        }
        if (privHiveObj == null && cols != null) {
            throw new SemanticException("For user-level privileges, column sets should be null. columns=" + cols.toString());
        }
        ShowGrantDesc showGrant = new ShowGrantDesc(this.ctx.getResFile().toString(), principalDesc, privHiveObj, cols);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showGrant), this.conf, new Task[0]));
    }

    private void analyzeGrant(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        boolean grantOption = false;
        PrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            for (int i = 2; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getType() == 208) {
                    grantOption = true;
                    continue;
                }
                if (astChild.getType() != 218) continue;
                privilegeObj = this.analyzePrivilegeObject(astChild, this.getOutputs());
            }
        }
        String userName = null;
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            userName = SessionState.get().getAuthenticator().getUserName();
        }
        GrantDesc grantDesc = new GrantDesc(privilegeObj, privilegeDesc, principalDesc, userName, PrincipalType.USER, grantOption);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), grantDesc), this.conf, new Task[0]));
    }

    private void analyzeRevoke(ASTNode ast) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        PrivilegeObjectDesc hiveObj = null;
        if (ast.getChildCount() > 2) {
            ASTNode astChild = (ASTNode)ast.getChild(2);
            hiveObj = this.analyzePrivilegeObject(astChild, this.getOutputs());
        }
        RevokeDesc revokeDesc = new RevokeDesc(privilegeDesc, principalDesc, hiveObj);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), revokeDesc), this.conf, new Task[0]));
    }

    private PrivilegeObjectDesc analyzePrivilegeObject(ASTNode ast, HashSet<WriteEntity> outputs) throws SemanticException {
        PrivilegeObjectDesc subject = new PrivilegeObjectDesc();
        subject.setObject(DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()));
        if (ast.getChildCount() > 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getToken().getType() == 11) {
                    subject.setPartSpec(DDLSemanticAnalyzer.getPartSpec(astChild));
                    continue;
                }
                subject.setTable(ast.getChild(0) != null);
            }
        }
        try {
            if (subject.getTable()) {
                Table tbl = this.db.getTable(subject.getObject());
                if (subject.getPartSpec() != null) {
                    Partition part = this.db.getPartition(tbl, subject.getPartSpec(), false);
                    outputs.add(new WriteEntity(part));
                } else {
                    outputs.add(new WriteEntity(tbl));
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        return subject;
    }

    private List<PrincipalDesc> analyzePrincipalListDef(ASTNode node) {
        ArrayList<PrincipalDesc> principalList = new ArrayList<PrincipalDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            PrincipalType type = null;
            switch (child.getType()) {
                case 205: {
                    type = PrincipalType.USER;
                    break;
                }
                case 206: {
                    type = PrincipalType.GROUP;
                    break;
                }
                case 207: {
                    type = PrincipalType.ROLE;
                }
            }
            String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
            PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
            principalList.add(principalDesc);
        }
        return principalList;
    }

    private List<PrivilegeDesc> analyzePrivilegeListDef(ASTNode node) throws SemanticException {
        ArrayList<PrivilegeDesc> ret = new ArrayList<PrivilegeDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode privilegeDef = (ASTNode)node.getChild(i);
            ASTNode privilegeType = (ASTNode)privilegeDef.getChild(0);
            Privilege privObj = PrivilegeRegistry.getPrivilege(privilegeType.getType());
            if (privObj == null) {
                throw new SemanticException("undefined privilege " + privilegeType.getType());
            }
            List<String> cols = null;
            if (privilegeDef.getChildCount() > 1) {
                cols = this.getColumnNames((ASTNode)privilegeDef.getChild(1));
            }
            PrivilegeDesc privilegeDesc = new PrivilegeDesc(privObj, cols);
            ret.add(privilegeDesc);
        }
        return ret;
    }

    private void analyzeCreateRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.CREATE_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeDropRole(ASTNode ast) {
        String roleName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.DROP_ROLE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeShowRoleGrant(ASTNode ast) {
        ASTNode child = (ASTNode)ast.getChild(0);
        PrincipalType principalType = PrincipalType.USER;
        switch (child.getType()) {
            case 205: {
                principalType = PrincipalType.USER;
                break;
            }
            case 206: {
                principalType = PrincipalType.GROUP;
                break;
            }
            case 207: {
                principalType = PrincipalType.ROLE;
            }
        }
        String principalName = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
        RoleDDLDesc createRoleDesc = new RoleDDLDesc(principalName, principalType, RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, null);
        createRoleDesc.setResFile(this.ctx.getResFile().toString());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createRoleDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 226: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, null, null, false);
        alterDesc.setDatabaseProperties(dbProps);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterDesc), this.conf, new Task[0]));
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 181: {
                    ifNotExists = true;
                    continue block6;
                }
                case 129: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 226: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 227: {
                    dbLocation = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(dbName, dbComment, dbLocation, ifNotExists);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(180)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(234)) {
            ifCascade = true;
        }
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists, ifCascade);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeSwitchDatabase(ASTNode ast) {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropTable(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        boolean ifExists = ast.getFirstChildWithType(180) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, throwException);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectView, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeCreateIndex(ASTNode ast) throws SemanticException {
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String typeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(2));
        List<String> indexedCols = this.getColumnNames((ASTNode)ast.getChild(3));
        HiveIndex.IndexType indexType = HiveIndex.getIndexType(typeName);
        if (indexType != null) {
            typeName = indexType.getHandlerClsName();
        } else {
            try {
                Class.forName(typeName);
            }
            catch (Exception e) {
                throw new SemanticException("class name provided for index handler not found.", e);
            }
        }
        String indexTableName = null;
        boolean deferredRebuild = false;
        String location = null;
        HashMap<String, String> tblProps = null;
        HashMap<String, String> idxProps = null;
        String indexComment = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        BaseSemanticAnalyzer.StorageFormat storageFormat = new BaseSemanticAnalyzer.StorageFormat();
        BaseSemanticAnalyzer.AnalyzeCreateCommonVars shared = new BaseSemanticAnalyzer.AnalyzeCreateCommonVars();
        block12: for (int idx = 4; idx < ast.getChildCount(); ++idx) {
            ASTNode child = (ASTNode)ast.getChild(idx);
            if (storageFormat.fillStorageFormat(child, shared)) continue;
            switch (child.getToken().getType()) {
                case 135: {
                    rowFormatParams.analyzeRowFormat(shared, child);
                    continue block12;
                }
                case 90: {
                    ASTNode ch = (ASTNode)child.getChild(0);
                    indexTableName = DDLSemanticAnalyzer.getUnescapedName(ch);
                    continue block12;
                }
                case 91: {
                    deferredRebuild = true;
                    continue block12;
                }
                case 153: {
                    location = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block12;
                }
                case 173: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 175: {
                    idxProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 172: {
                    child = (ASTNode)child.getChild(0);
                    shared.serde = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    if (child.getChildCount() != 2) continue block12;
                    DDLSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), shared.serdeProps);
                    continue block12;
                }
                case 224: {
                    child = (ASTNode)child.getChild(0);
                    indexComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(shared);
        CreateIndexDesc crtIndexDesc = new CreateIndexDesc(tableName, indexName, indexedCols, indexTableName, deferredRebuild, storageFormat.inputFormat, storageFormat.outputFormat, storageFormat.storageHandler, typeName, location, idxProps, tblProps, shared.serde, shared.serdeProps, rowFormatParams.collItemDelim, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.lineDelim, rowFormatParams.mapKeyDelim, indexComment);
        Task<DDLWork> createIndex = TaskFactory.get(new DDLWork(crtIndexDesc), this.conf, new Task[0]);
        this.rootTasks.add(createIndex);
    }

    private void analyzeDropIndex(ASTNode ast) throws SemanticException {
        boolean throwException;
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
        boolean ifExists = ast.getFirstChildWithType(180) != null;
        boolean bl = throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        if (throwException) {
            try {
                Index idx = this.db.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                throw new SemanticException(ErrorMsg.INVALID_INDEX.getMsg(indexName));
            }
        }
        DropIndexDesc dropIdxDesc = new DropIndexDesc(indexName, tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropIdxDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterIndexRebuild(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> partSpec = null;
        Tree part = ast.getChild(2);
        if (part != null) {
            partSpec = this.extractPartitionSpecs(part);
        }
        List<Task<?>> indexBuilder = this.getIndexBuilderMapRed(baseTableName, indexName, partSpec);
        this.rootTasks.addAll(indexBuilder);
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.UPDATETIMESTAMP);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(baseTableName);
        alterIdxDesc.setDbName(this.db.getCurrentDatabase());
        alterIdxDesc.setSpec(partSpec);
        Task<DDLWork> tsTask = TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]);
        for (Task<?> t : indexBuilder) {
            t.addDependentTask(tsTask);
        }
    }

    private void analyzeAlterIndexProps(ASTNode ast) throws SemanticException {
        String baseTableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.ADDPROPS);
        alterIdxDesc.setProps(mapProp);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(baseTableName);
        alterIdxDesc.setDbName(this.db.getCurrentDatabase());
        this.rootTasks.add(TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]));
    }

    private List<Task<?>> getIndexBuilderMapRed(String baseTableName, String indexName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            String dbName = this.db.getCurrentDatabase();
            Index index = this.db.getIndex(dbName, baseTableName, indexName);
            Table indexTbl = this.db.getTable(dbName, index.getIndexTableName());
            String baseTblName = index.getOrigTableName();
            Table baseTbl = this.db.getTable(dbName, baseTblName);
            String handlerCls = index.getIndexHandlerClass();
            HiveIndexHandler handler = HiveUtils.getIndexHandler(this.conf, handlerCls);
            ArrayList<Partition> indexTblPartitions = null;
            List<Partition> baseTblPartitions = null;
            if (indexTbl != null) {
                indexTblPartitions = new ArrayList<Partition>();
                baseTblPartitions = this.preparePartitions(baseTbl, partSpec, indexTbl, this.db, indexTblPartitions);
            }
            List<Task<?>> ret = handler.generateIndexBuildTaskList(baseTbl, index, indexTblPartitions, baseTblPartitions, indexTbl, this.getInputs(), this.getOutputs());
            return ret;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Partition> preparePartitions(Table baseTbl, HashMap<String, String> partSpec, Table indexTbl, Hive db, List<Partition> indexTblPartitions) throws HiveException, MetaException {
        List<Partition> baseTblPartitions = new ArrayList<Partition>();
        if (partSpec != null) {
            Partition part = db.getPartition(baseTbl, partSpec, false);
            if (part == null) {
                throw new HiveException("Partition " + Warehouse.makePartName(partSpec, (boolean)false) + " does not exist in table " + baseTbl.getTableName());
            }
            baseTblPartitions.add(part);
            Partition indexPart = db.getPartition(indexTbl, partSpec, false);
            if (indexPart == null) {
                indexPart = db.createPartition(indexTbl, partSpec);
            }
            indexTblPartitions.add(indexPart);
        } else if (baseTbl.isPartitioned()) {
            baseTblPartitions = db.getPartitions(baseTbl);
            for (Partition basePart : baseTblPartitions) {
                LinkedHashMap<String, String> pSpec = basePart.getSpec();
                Partition indexPart = db.getPartition(indexTbl, pSpec, false);
                if (indexPart == null) {
                    indexPart = db.createPartition(indexTbl, pSpec);
                }
                indexTblPartitions.add(indexPart);
            }
        }
        return baseTblPartitions;
    }

    private void analyzeAlterTableProps(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, expectView);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 1) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String inputFormat = null;
        String outputFormat = null;
        String storageHandler = null;
        String serde = null;
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 143: {
                inputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(0)).getToken().getText());
                outputFormat = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(inputFormat);
                    Class.forName(outputFormat);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 150: {
                storageHandler = DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)child.getChild(1)).getToken().getText());
                try {
                    Class.forName(storageHandler);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException(e);
                }
            }
            case 140: {
                inputFormat = SEQUENCEFILE_INPUT;
                outputFormat = SEQUENCEFILE_OUTPUT;
                break;
            }
            case 141: {
                inputFormat = TEXTFILE_INPUT;
                outputFormat = TEXTFILE_OUTPUT;
                break;
            }
            case 142: {
                inputFormat = RCFILE_INPUT;
                outputFormat = RCFILE_OUTPUT;
                serde = COLUMNAR_SERDE;
                break;
            }
            case 144: {
                this.handleGenericFileFormat(child);
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, inputFormat, outputFormat, serde, storageHandler, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void addInputsOutputsAlterTable(String tableName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                if (partSpec == null || partSpec.isEmpty()) {
                    this.outputs.add(new WriteEntity(tab));
                } else {
                    Partition part = this.db.getPartition(tab, partSpec, false);
                    if (part != null) {
                        this.outputs.add(new WriteEntity(part));
                    }
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
    }

    private void analyzeAlterTableLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, newLocation, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProtectMode(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 146: {
                alterTblDesc.setProtectModeEnable(true);
                break;
            }
            case 147: {
                alterTblDesc.setProtectModeEnable(false);
                break;
            }
            default: {
                throw new SemanticException("Set Protect mode Syntax parsing error.");
            }
        }
        ASTNode grandChild = (ASTNode)child.getChild(0);
        switch (grandChild.getToken().getType()) {
            case 145: {
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.OFFLINE);
                break;
            }
            case 149: {
                if (grandChild.getChildCount() > 0) {
                    alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP_CASCADE);
                    break;
                }
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP);
                break;
            }
            case 148: {
                throw new SemanticException("Potect mode READONLY is not implemented");
            }
            default: {
                throw new SemanticException("Only protect mode NO_DROP or OFFLINE supported");
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTablePartMergeFiles(ASTNode tablePartAST, ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTablePartMergeFilesDesc mergeDesc = new AlterTablePartMergeFilesDesc(tableName, partSpec);
        ArrayList<String> inputDir = new ArrayList<String>();
        String tblPartLoc = null;
        Table tblObj = null;
        try {
            List<Index> indexes;
            tblObj = this.db.getTable(tableName);
            List<String> bucketCols = null;
            Class<? extends InputFormat> inputFormatClass = null;
            boolean isArchived = false;
            boolean checkIndex = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_CONCATENATE_CHECK_INDEX);
            if (checkIndex && (indexes = this.db.getIndexes(tblObj.getDbName(), tableName, (short)Short.MAX_VALUE)) != null && indexes.size() > 0) {
                throw new SemanticException("can not do merge because source table " + tableName + " is indexed.");
            }
            if (tblObj.isPartitioned()) {
                if (partSpec == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but no partition desc found.");
                }
                Partition part = this.db.getPartition(tblObj, partSpec, false);
                if (part == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but partition not found.");
                }
                bucketCols = part.getBucketCols();
                inputFormatClass = part.getInputFormatClass();
                isArchived = ArchiveUtils.isArchived(part);
                tblPartLoc = part.getDataLocation().toString();
            } else {
                inputFormatClass = tblObj.getInputFormatClass();
                bucketCols = tblObj.getBucketCols();
                tblPartLoc = tblObj.getDataLocation().toString();
            }
            if (!inputFormatClass.equals(RCFileInputFormat.class)) {
                throw new SemanticException("Only RCFileFormat is supportted right now.");
            }
            if (bucketCols != null && bucketCols.size() > 0) {
                throw new SemanticException("Merge can not perform on bucketized partition/table.");
            }
            if (isArchived) {
                throw new SemanticException("Merge can not perform on archived partitions.");
            }
            inputDir.add(tblPartLoc);
            mergeDesc.setInputDir(inputDir);
            this.addInputsOutputsAlterTable(tableName, partSpec);
            DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), mergeDesc);
            ddlWork.setNeedLock(true);
            Task<DDLWork> mergeTask = TaskFactory.get(ddlWork, this.conf, new Task[0]);
            TableDesc tblDesc = Utilities.getTableDesc(tblObj);
            String queryTmpdir = this.ctx.getExternalTmpFileURI(new URI(tblPartLoc));
            mergeDesc.setOutputDir(queryTmpdir);
            LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, queryTmpdir, tblDesc, partSpec == null ? new HashMap() : partSpec);
            Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
            mergeTask.addDependentTask(moveTsk);
            BaseSemanticAnalyzer.tableSpec tablepart = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, tablePartAST);
            StatsWork statDesc = new StatsWork(tablepart);
            statDesc.setNoStatsAggregator(true);
            Task<StatsWork> statTask = TaskFactory.get(statDesc, this.conf, new Task[0]);
            moveTsk.addDependentTask(statTask);
            this.rootTasks.add(mergeTask);
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void analyzeAlterTableClusterSort(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tableName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
        }
        if (ast.getChildCount() == 1) {
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, -1, new ArrayList<String>(), new ArrayList<Order>());
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        } else {
            ASTNode buckets = (ASTNode)ast.getChild(1);
            List<String> bucketCols = this.getColumnNames((ASTNode)buckets.getChild(0));
            ArrayList<Order> sortCols = new ArrayList();
            int numBuckets = -1;
            if (buckets.getChildCount() == 2) {
                numBuckets = Integer.valueOf(buckets.getChild(1).getText());
            } else {
                sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                numBuckets = Integer.valueOf(buckets.getChild(2).getText());
            }
            if (numBuckets <= 0) {
                throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
            }
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        }
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private String getFullyQualifiedName(ASTNode ast) {
        if (ast.getChildCount() == 0) {
            return ast.getText();
        }
        return this.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + this.getFullyQualifiedName((ASTNode)ast.getChild(1));
    }

    private FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        FetchWork fetch = new FetchWork(this.ctx.getResFile().toString(), new TableDesc(LazySimpleSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        HashMap<String, String> partSpec = null;
        if (tableTypeExpr.getChildCount() == 2) {
            ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
            partSpec = DDLSemanticAnalyzer.getPartSpec(partspec);
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec);
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 237);
            descTblDesc.setExt(descOptions == 236);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(DescTableDesc.getSchema()));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private void analyzeDescDatabase(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.ctx.getResFile(), dbName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descDbDesc.getSchema()));
    }

    private static HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        String dbName = this.db.getCurrentDatabase();
        String tableNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 9);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 9);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            default: {
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
            }
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String dbName = this.db.getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 261) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 11) {
                    partSpec = DDLSemanticAnalyzer.getPartSpec(child);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowIndexes(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowIndexesDesc showIndexesDesc = new ShowIndexesDesc(tableName, this.ctx.getResFile());
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            showIndexesDesc.setFormatted(descOptions == 237);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showIndexesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showIndexesDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeShowLocks(ASTNode ast) throws SemanticException {
        String tableName = null;
        HashMap<String, String> partSpec = null;
        boolean isExtended = false;
        if (ast.getChildCount() >= 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getType() == 177) {
                    ASTNode tableTypeExpr = child;
                    tableName = this.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
                    if (tableTypeExpr.getChildCount() != 2) continue;
                    ASTNode partspec = (ASTNode)tableTypeExpr.getChild(1);
                    partSpec = DDLSemanticAnalyzer.getPartSpec(partspec);
                    continue;
                }
                if (child.getType() != 236) continue;
                isExtended = true;
            }
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partSpec, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeLockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0)).toLowerCase();
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        LockTableDesc lockTblDesc = new LockTableDesc(tableName, mode, partSpec, HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID));
        lockTblDesc.setQueryStr(this.ctx.getCmd());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), lockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeUnlockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        UnlockTableDesc unlockTblDesc = new UnlockTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), unlockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(ASTNode ast, boolean expectView) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1)), expectView);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(ASTNode ast) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String newComment = null;
        String newType = null;
        newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(3));
        boolean first = false;
        String flagCol = null;
        ASTNode positionNode = null;
        if (ast.getChildCount() == 6) {
            newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            positionNode = (ASTNode)ast.getChild(5);
        } else if (ast.getChildCount() == 5) {
            if (ast.getChild(4).getType() == 242) {
                newComment = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(4).getText());
            } else {
                positionNode = (ASTNode)ast.getChild(4);
            }
        }
        if (positionNode != null) {
            if (positionNode.getChildCount() == 0) {
                first = true;
            } else {
                flagCol = DDLSemanticAnalyzer.unescapeIdentifier(positionNode.getChild(0).getText());
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText()), DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(2).getText()), newType, newComment, first, flagCol);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenamePart(ASTNode ast, String tblName, HashMap<String, String> oldPartSpec) throws SemanticException {
        HashMap<String, String> newPartSpec = this.extractPartitionSpecs((Tree)((ASTNode)ast.getChild(0)));
        if (newPartSpec == null) {
            throw new SemanticException("RENAME PARTITION Missing Destination" + ast);
        }
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab == null) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
            }
            this.inputs.add(new ReadEntity(tab));
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        partSpecs.add(oldPartSpec);
        partSpecs.add(newPartSpec);
        this.addTablePartsOutputs(tblName, partSpecs);
        RenamePartitionDesc renamePartitionDesc = new RenamePartitionDesc(this.db.getCurrentDatabase(), tblName, oldPartSpec, newPartSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), renamePartitionDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(ASTNode ast, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(1));
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, newCols, alterType);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                this.outputs.add(new WriteEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(ASTNode ast, boolean expectView) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        DropTableDesc dropTblDesc = new DropTableDesc(tblName, partSpecs, expectView);
        try {
            Table tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        if (partSpecs != null) {
            boolean ifExists = ast.getFirstChildWithType(180) != null;
            boolean throwException = !ifExists && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
            this.addTablePartsOutputs(tblName, partSpecs, throwException, false, ast);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(CommonTree ast, boolean expectView) throws SemanticException {
        Table tab;
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        boolean isView = false;
        try {
            tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
                isView = tab.isView();
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        this.addTablePartsOutputs(tblName, partSpecs);
        Iterator<Map<String, String>> partIter = partSpecs.iterator();
        String currentLocation = null;
        Map<String, String> currentPart = null;
        boolean ifNotExists = false;
        ArrayList<AddPartitionDesc> partitionDescs = new ArrayList<AddPartitionDesc>();
        int numCh = ast.getChildCount();
        block9: for (int num = 1; num < numCh; ++num) {
            CommonTree child = (CommonTree)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 181: {
                    ifNotExists = true;
                    continue block9;
                }
                case 11: {
                    if (currentPart != null) {
                        this.validatePartitionValues(currentPart);
                        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists, expectView);
                        partitionDescs.add(addPartitionDesc);
                    }
                    currentLocation = null;
                    currentPart = partIter.next();
                    continue block9;
                }
                case 154: {
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            this.validatePartitionValues(currentPart);
            AddPartitionDesc addPartitionDesc = new AddPartitionDesc(this.db.getCurrentDatabase(), tblName, currentPart, currentLocation, ifNotExists, expectView);
            partitionDescs.add(addPartitionDesc);
        }
        for (AddPartitionDesc addPartitionDesc : partitionDescs) {
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        }
        if (isView) {
            StringBuilder cmd = new StringBuilder();
            cmd.append("SELECT * FROM ");
            cmd.append(HiveUtils.unparseIdentifier(tblName));
            cmd.append(" WHERE ");
            boolean firstOr = true;
            for (AddPartitionDesc partitionDesc : partitionDescs) {
                try {
                    tab.isValidSpec(partitionDesc.getPartSpec());
                }
                catch (HiveException ex) {
                    throw new SemanticException(ex.getMessage(), ex);
                }
                if (firstOr) {
                    firstOr = false;
                } else {
                    cmd.append(" OR ");
                }
                boolean firstAnd = true;
                cmd.append("(");
                for (Map.Entry<String, String> entry : partitionDesc.getPartSpec().entrySet()) {
                    if (firstAnd) {
                        firstAnd = false;
                    } else {
                        cmd.append(" AND ");
                    }
                    cmd.append(HiveUtils.unparseIdentifier(entry.getKey()));
                    cmd.append(" = '");
                    cmd.append(HiveUtils.escapeString(entry.getValue()));
                    cmd.append("'");
                }
                cmd.append(")");
            }
            Driver driver = new Driver(this.conf);
            int rc = driver.compile(cmd.toString());
            if (rc != 0) {
                throw new SemanticException(ErrorMsg.NO_VALID_PARTN.getMsg());
            }
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }

    private void analyzeAlterTableTouch(CommonTree ast) throws SemanticException {
        Table tab;
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        try {
            tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.outputs.add(new WriteEntity(tab));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
        } else {
            this.addTablePartsOutputs(tblName, partSpecs);
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
            }
        }
    }

    private void analyzeAlterTableArchive(CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(ast);
        Table tab = null;
        try {
            tab = this.db.getTable(this.db.getCurrentDatabase(), tblName, false);
            if (tab != null) {
                this.inputs.add(new ReadEntity(tab));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        this.addTablePartsOutputs(tblName, partSpecs, true);
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        try {
            this.isValidPrefixSpec(tab, partSpec);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(this.db.getCurrentDatabase(), tblName, partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc), this.conf, new Task[0]));
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 341;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 1; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partspec = ast.getChild(childIndex);
            if (partspec.getType() != 11) continue;
            LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
            for (int i = 0; i < partspec.getChildCount(); ++i) {
                CommonTree partspec_val = (CommonTree)partspec.getChild(i);
                String val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
                partSpec.put(partspec_val.getChild(0).getText().toLowerCase(), val);
            }
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                if (!e.getValue().contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs) throws SemanticException {
        this.addTablePartsOutputs(tblName, partSpecs, false, false, null);
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs, boolean allowMany) throws SemanticException {
        this.addTablePartsOutputs(tblName, partSpecs, false, allowMany, null);
    }

    private void addTablePartsOutputs(String tblName, List<Map<String, String>> partSpecs, boolean throwIfNonExistent, boolean allowMany, ASTNode ast) throws SemanticException {
        Table tab;
        try {
            tab = this.db.getTable(tblName);
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tblName));
        }
        Iterator<Map<String, String>> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            Map<String, String> partSpec = i.next();
            List<Object> parts = null;
            if (allowMany) {
                try {
                    parts = this.db.getPartitions(tab, partSpec);
                }
                catch (HiveException e) {
                    LOG.error((Object)"Got HiveException during obtaining list of partitions");
                }
            } else {
                parts = new ArrayList();
                try {
                    Partition p = this.db.getPartition(tab, partSpec, false);
                    if (p != null) {
                        parts.add(p);
                    }
                }
                catch (HiveException e) {
                    LOG.debug((Object)"Wrong specification");
                }
            }
            if (parts.isEmpty() && throwIfNonExistent) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(index)));
            }
            for (Partition partition : parts) {
                this.outputs.add(new WriteEntity(partition));
            }
            ++index;
        }
    }

    static {
        TokenToTypeName.put(74, "boolean");
        TokenToTypeName.put(70, "tinyint");
        TokenToTypeName.put(71, "smallint");
        TokenToTypeName.put(72, "int");
        TokenToTypeName.put(73, "bigint");
        TokenToTypeName.put(75, "float");
        TokenToTypeName.put(76, "double");
        TokenToTypeName.put(80, "string");
        TokenToTypeName.put(81, "binary");
        TokenToTypeName.put(77, "date");
        TokenToTypeName.put(78, "datetime");
        TokenToTypeName.put(79, "timestamp");
    }

    static class TablePartition {
        String tableName;
        HashMap<String, String> partSpec = null;

        public TablePartition() {
        }

        public TablePartition(ASTNode tblPart) throws SemanticException {
            ASTNode part;
            this.tableName = BaseSemanticAnalyzer.unescapeIdentifier(tblPart.getChild(0).getText());
            if (tblPart.getChildCount() > 1 && (part = (ASTNode)tblPart.getChild(1)).getToken().getType() == 11) {
                this.partSpec = DDLSemanticAnalyzer.getPartSpec(part);
            }
        }
    }
}

