/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class DeleteResourceProcessor
implements CommandProcessor {
    public static final Log LOG = LogFactory.getLog((String)DeleteResourceProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState.ResourceType t;
        SessionState ss = SessionState.get();
        command = new VariableSubstitution().substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 1 || (t = SessionState.find_resource_type(tokens[0])) == null) {
            console.printError("Usage: delete [" + StringUtils.join((Object[])SessionState.ResourceType.values(), "|") + "] <value> [<value>]*");
            return new CommandProcessorResponse(1);
        }
        if (tokens.length >= 2) {
            for (int i = 1; i < tokens.length; ++i) {
                ss.delete_resource(t, tokens[i]);
            }
        } else {
            ss.delete_resource(t);
        }
        return new CommandProcessorResponse(0);
    }
}

