/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="ln", value="_FUNC_(x) - Returns the natural logarithm of x", extended="Example:\n  > SELECT _FUNC_(1) FROM src LIMIT 1;\n  0")
public class UDFLn
extends UDF {
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()));
        return this.result;
    }
}

