/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;

public final class ColumnProjectionUtils {
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";

    public static void setReadColumnIDs(Configuration conf, ArrayList<Integer> ids) {
        String id = ColumnProjectionUtils.toReadColumnIDString(ids);
        ColumnProjectionUtils.setReadColumnIDConf(conf, id);
    }

    public static void appendReadColumnIDs(Configuration conf, ArrayList<Integer> ids) {
        String id = ColumnProjectionUtils.toReadColumnIDString(ids);
        if (id != null) {
            String old = conf.get(READ_COLUMN_IDS_CONF_STR, null);
            String newConfStr = id;
            if (old != null) {
                newConfStr = newConfStr + "," + old;
            }
            ColumnProjectionUtils.setReadColumnIDConf(conf, newConfStr);
        }
    }

    private static void setReadColumnIDConf(Configuration conf, String id) {
        if (id == null || id.length() <= 0) {
            conf.set(READ_COLUMN_IDS_CONF_STR, "");
            return;
        }
        conf.set(READ_COLUMN_IDS_CONF_STR, id);
    }

    private static String toReadColumnIDString(ArrayList<Integer> ids) {
        String id = null;
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                id = i == 0 ? "" + ids.get(i) : id + "," + ids.get(i);
            }
        }
        return id;
    }

    public static ArrayList<Integer> getReadColumnIDs(Configuration conf) {
        if (conf == null) {
            return new ArrayList<Integer>(0);
        }
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, "");
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static void setFullyReadColumns(Configuration conf) {
        conf.set(READ_COLUMN_IDS_CONF_STR, "");
    }

    private ColumnProjectionUtils() {
    }
}

