/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.job;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.jaxb.JobSummariesListWrapper;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobSourceModel;
import com.jaspersoft.jasperserver.jaxrs.job.CalendarNameListWrapper;
import com.jaspersoft.jasperserver.jaxrs.job.JobIdListWrapper;
import com.jaspersoft.jasperserver.jaxrs.job.JobsServiceCallTemplate;
import com.jaspersoft.jasperserver.jaxrs.job.ReportJobModelJsonParam;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.JobsService;
import com.jaspersoft.jasperserver.remote.services.impl.ReportJobCalendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/jobs")
@CallTemplate(value=JobsServiceCallTemplate.class)
public class JobsJaxrsService
extends RemoteServiceWrapper<JobsService> {
    @Resource(name="jobsService")
    public void setRemoteService(JobsService remoteService) {
        this.remoteService = remoteService;
    }

    @DELETE
    @Path(value="/{id: \\d+}")
    public Response deleteJob(final @PathParam(value="id") long id) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                service.deleteJob(id);
                return Response.ok().build();
            }
        });
    }

    @DELETE
    public Response deleteJobs(final @QueryParam(value="id") List<Long> ids) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                long[] idsArray = new long[ids.size()];
                for (int i = 0; i < ids.size(); ++i) {
                    idsArray[i] = (Long)ids.get(i);
                }
                service.deleteJobs(idsArray);
                return Response.ok().build();
            }
        });
    }

    @GET
    @Path(value="/{id: \\d+}")
    @Produces(value={"application/xml", "application/json"})
    public Response getJob(final @PathParam(value="id") long id) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                ReportJob job = service.getJob(id);
                if (job != null) {
                    return Response.ok((Object)job).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        });
    }

    @PUT
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response scheduleJob(final ReportJob reportJob) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                return Response.ok((Object)service.scheduleJob(reportJob)).build();
            }
        });
    }

    @POST
    @Path(value="/{id: \\d+}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response updateJob(final @PathParam(value="id") long id, final ReportJob reportJob) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                if (id != reportJob.getId()) {
                    reportJob.setId(id);
                }
                return Response.ok((Object)service.updateJob(reportJob)).build();
            }
        });
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response updateJobs(final @QueryParam(value="id") List<Long> jobIds, final ReportJobModel jobModel, final @QueryParam(value="replaceTriggerIgnoreType") @DefaultValue(value="false") Boolean replaceTriggerIgnoreType) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.updateReportJobs(jobIds, jobModel, replaceTriggerIgnoreType);
                return Response.ok().build();
            }
        });
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getReportJobs(final @QueryParam(value="reportUnitURI") String reportURI, final @QueryParam(value="owner") String owner, final @QueryParam(value="label") String jobName, final @QueryParam(value="state") String state, final @QueryParam(value="previousFireTime") Date previousFireTime, final @QueryParam(value="nextFireTime") Date nextFireTime, final @QueryParam(value="example") ReportJobModelJsonParam exampleConverter, final @QueryParam(value="startIndex") Integer startIndex, final @QueryParam(value="numberOfRows") Integer numberOfRows, final @QueryParam(value="sortType") ReportJobModel.ReportJobSortType sortType, final @QueryParam(value="isAscending") Boolean isAscending) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                List result;
                ReportJobModel criteriaObject;
                ReportJobModel reportJobModel = criteriaObject = exampleConverter != null ? (ReportJobModel)exampleConverter.getObject() : null;
                if (reportURI != null || owner != null || jobName != null || state != null || previousFireTime != null || nextFireTime != null) {
                    if (criteriaObject == null) {
                        criteriaObject = new ReportJobModel();
                    }
                    if (reportURI != null && (criteriaObject.getSourceModel() == null || criteriaObject.getSourceModel().getReportUnitURI() == null)) {
                        if (criteriaObject.getSourceModel() == null) {
                            criteriaObject.setSourceModel(new ReportJobSourceModel());
                        }
                        criteriaObject.getSourceModel().setReportUnitURI(reportURI);
                    }
                    if (owner != null && criteriaObject.getUsername() == null) {
                        criteriaObject.setUsername(owner);
                    }
                    if (jobName != null && criteriaObject.getLabel() == null) {
                        criteriaObject.setLabel(jobName);
                    }
                    if (state != null) {
                        // empty if block
                    }
                    if (previousFireTime != null) {
                        // empty if block
                    }
                    if (nextFireTime != null) {
                        // empty if block
                    }
                }
                return (result = service.getJobSummariesByExample(criteriaObject, startIndex, numberOfRows, sortType, isAscending)) != null && !result.isEmpty() ? Response.ok((Object)new JobSummariesListWrapper(result)).build() : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @GET
    @Path(value="/{id: \\d+}/state")
    @Produces(value={"application/xml", "application/json"})
    public Response getJobState(final @PathParam(value="id") long id) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService service) throws RemoteException {
                ReportJobRuntimeInformation reportJobState = service.getReportJobState(id);
                if (reportJobState != null) {
                    return Response.ok((Object)reportJobState).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        });
    }

    @POST
    @Path(value="/pause")
    @Consumes(value={"application/xml", "application/json"})
    public Response pause(final JobIdListWrapper jobIdListWrapper) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.pause(jobIdListWrapper.getIds());
                return Response.ok().build();
            }
        });
    }

    @POST
    @Path(value="/resume")
    @Consumes(value={"application/xml", "application/json"})
    public Response resume(final JobIdListWrapper jobIdListWrapper) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.resume(jobIdListWrapper.getIds());
                return Response.ok().build();
            }
        });
    }

    @POST
    @Path(value="/restart")
    @Consumes(value={"application/xml", "application/json"})
    public Response scheduleJobsOnceNow(final JobIdListWrapper jobIdListWrapper) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.scheduleJobsOnceNow(jobIdListWrapper.getIds());
                return Response.ok().build();
            }
        });
    }

    @GET
    @Path(value="/calendars")
    @Produces(value={"application/xml", "application/json"})
    public Response getCalendarNames() {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                List calendarNames = remoteService.getCalendarNames();
                if (calendarNames != null && !calendarNames.isEmpty()) {
                    return Response.ok((Object)new CalendarNameListWrapper(calendarNames)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @GET
    @Path(value="/calendars/{calendarName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getCalendarByName(final @PathParam(value="calendarName") String calendarName) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                ReportJobCalendar calendar = remoteService.getCalendar(calendarName);
                if (calendar != null) {
                    return Response.ok((Object)calendar).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        });
    }

    @DELETE
    @Path(value="/calendars/{calendarName}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteCalendar(final @PathParam(value="calendarName") String calendarName) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.deleteCalendar(calendarName);
                return Response.ok().build();
            }
        });
    }

    @PUT
    @Path(value="/calendars/{calendarName}")
    @Produces(value={"application/xml", "application/json"})
    public Response putCalendar(final @PathParam(value="calendarName") String calendarName, final ReportJobCalendar calendar, final @QueryParam(value="replace") @DefaultValue(value="false") Boolean replace, final @QueryParam(value="updateTriggers") @DefaultValue(value="false") Boolean updateTriggers) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(JobsService remoteService) throws RemoteException {
                remoteService.addCalendar(calendarName, calendar, replace, updateTriggers);
                return Response.ok().build();
            }
        });
    }
}

