/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Cell;
import mondrian.olap.Property;
import mondrian.olap4j.MondrianOlap4jCellSet;
import mondrian.rolap.RolapCell;
import mondrian.rolap.SqlStatement;
import org.olap4j.AllocationPolicy;
import org.olap4j.CellSet;
import org.olap4j.OlapException;
import org.olap4j.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jCell
implements org.olap4j.Cell {
    private final int[] coordinates;
    private final MondrianOlap4jCellSet olap4jCellSet;
    private final Cell cell;

    MondrianOlap4jCell(int[] coordinates, MondrianOlap4jCellSet olap4jCellSet, Cell cell) {
        assert (coordinates != null);
        assert (olap4jCellSet != null);
        assert (cell != null);
        this.coordinates = coordinates;
        this.olap4jCellSet = olap4jCellSet;
        this.cell = cell;
    }

    public CellSet getCellSet() {
        return this.olap4jCellSet;
    }

    public int getOrdinal() {
        return (Integer)this.cell.getPropertyValue(Property.CELL_ORDINAL.name);
    }

    public List<Integer> getCoordinateList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.coordinates.length);
        for (int coordinate : this.coordinates) {
            list.add(coordinate);
        }
        return list;
    }

    public Object getPropertyValue(org.olap4j.metadata.Property property) {
        return this.cell.getPropertyValue(property.getName());
    }

    public boolean isEmpty() {
        return this.cell.isNull();
    }

    public boolean isError() {
        return this.cell.isError();
    }

    public boolean isNull() {
        return this.cell.isNull();
    }

    public double getDoubleValue() throws OlapException {
        Object o = this.cell.getValue();
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.doubleValue();
        }
        throw this.olap4jCellSet.olap4jStatement.olap4jConnection.helper.createException(this, "not a number");
    }

    public String getErrorText() {
        Object o = this.cell.getValue();
        if (o instanceof Throwable) {
            return ((Throwable)o).getMessage();
        }
        return null;
    }

    public Object getValue() {
        return this.cell.getValue();
    }

    public String getFormattedValue() {
        return this.cell.getFormattedValue();
    }

    public ResultSet drillThrough() throws OlapException {
        return this.drillThroughInternal(-1, -1);
    }

    ResultSet drillThroughInternal(int maxRowCount, int firstRowOrdinal) throws OlapException {
        SqlStatement sqlStmt = ((RolapCell)this.cell).drillThroughInternal(maxRowCount, firstRowOrdinal, null, false, null);
        return sqlStmt.getWrappedResultSet();
    }

    public void setValue(Object newValue, AllocationPolicy allocationPolicy, Object ... allocationArgs) {
        Scenario scenario = this.olap4jCellSet.olap4jStatement.olap4jConnection.getScenario();
        this.cell.setValue(scenario, newValue, allocationPolicy, allocationArgs);
    }
}

