/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.FileFormatter;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=AssemblyArchiverPhase.class, hint="file-items")
public class FileItemAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileItem> fileList = assembly.getFiles();
        File basedir = configSource.getBasedir();
        FileFormatter fileFormatter = new FileFormatter(configSource, this.getLogger());
        for (FileItem fileItem : fileList) {
            String outputDirectory;
            String sourcePath = fileItem.getSource();
            File source = new File(sourcePath);
            String sourceName = source.getName();
            if (!source.isAbsolute()) {
                source = new File(basedir, sourcePath);
            }
            source = fileFormatter.format(source, fileItem.isFiltered(), fileItem.getLineEnding(), configSource.getEncoding());
            String destName = fileItem.getDestName();
            if (destName == null) {
                destName = sourceName;
            }
            String target = (outputDirectory = AssemblyFormatUtils.getOutputDirectory(fileItem.getOutputDirectory(), configSource.getProject(), null, configSource.getFinalName(), configSource)).endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : (outputDirectory.length() < 1 ? destName : outputDirectory + "/" + destName);
            try {
                archiver.addFile(source, target, TypeConversionUtils.modeToInt(fileItem.getFileMode(), this.getLogger()));
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
        }
    }
}

