/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.sql.Timestamp;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.LongArrayStore;
import net.sf.jasperreports.data.cache.TimestampValues;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimestampStore
implements BufferColumnStore {
    private static final Log log = LogFactory.getLog(TimestampStore.class);
    private final LongArrayStore timeStore;
    private final LongArrayStore nanoStore;

    public TimestampStore(int size) {
        this.timeStore = new LongArrayStore(size, true);
        this.nanoStore = new LongArrayStore(size);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": created time store " + this.timeStore));
            log.debug((Object)(this + ": created nano store " + this.nanoStore));
        }
    }

    @Override
    public Class<?> getBaseValuesType() {
        return Timestamp.class;
    }

    @Override
    public void addValue(Object object) {
        if (!(object instanceof Timestamp)) {
            throw new IllegalArgumentException();
        }
        Timestamp value = (Timestamp)object;
        long time = value.getTime();
        int nanos = value.getNanos();
        this.timeStore.add(time);
        this.nanoStore.add(nanos);
    }

    @Override
    public boolean full() {
        return this.timeStore.full() || this.nanoStore.full();
    }

    @Override
    public void resetValues() {
        this.timeStore.resetValues();
        this.nanoStore.resetValues();
    }

    @Override
    public ColumnValues createValues() {
        ColumnValues timeValues = this.timeStore.createValues();
        ColumnValues nanoValues = this.nanoStore.createValues();
        return new TimestampValues(timeValues, nanoValues);
    }

    public String toString() {
        return "TimestampStore@" + this.hashCode();
    }
}

