/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XmlDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(XmlDataAdapterService.class);

    public XmlDataAdapterService(JasperReportsContext jasperReportsContext, XmlDataAdapter xmlDataAdapter) {
        super(jasperReportsContext, xmlDataAdapter);
    }

    public XmlDataAdapterService(XmlDataAdapter xmlDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), xmlDataAdapter);
    }

    public XmlDataAdapter getXmlDataAdapter() {
        return (XmlDataAdapter)this.getDataAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XmlDataAdapter xmlDataAdapter = this.getXmlDataAdapter();
        if (xmlDataAdapter != null) {
            if (xmlDataAdapter.isUseConnection()) {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                InputStream dataStream = RepositoryUtil.getInstance(this.getJasperReportsContext()).getInputStreamFromLocation(xmlDataAdapter.getFileName());
                try {
                    Document document = JRXmlUtils.parse(dataStream);
                    parameters.put("XML_DATA_DOCUMENT", document);
                }
                finally {
                    try {
                        dataStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Failed to close input stream for " + xmlDataAdapter.getFileName()));
                    }
                }
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    parameters.put("XML_LOCALE", locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    parameters.put("XML_TIME_ZONE", timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    parameters.put("XML_DATE_PATTERN", datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    parameters.put("XML_NUMBER_PATTERN", numberPattern);
                }
            } else {
                String numberPattern;
                String datePattern;
                TimeZone timeZone;
                JRXmlDataSource ds = new JRXmlDataSource(this.getJasperReportsContext(), xmlDataAdapter.getFileName(), xmlDataAdapter.getSelectExpression());
                Locale locale = xmlDataAdapter.getLocale();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if ((timeZone = xmlDataAdapter.getTimeZone()) != null) {
                    ds.setTimeZone(timeZone);
                }
                if ((datePattern = xmlDataAdapter.getDatePattern()) != null && datePattern.trim().length() > 0) {
                    ds.setDatePattern(datePattern);
                }
                if ((numberPattern = xmlDataAdapter.getNumberPattern()) != null && numberPattern.trim().length() > 0) {
                    ds.setNumberPattern(numberPattern);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }
}

