/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;

public class JRBaseComponentElement
extends JRBaseElement
implements JRComponentElement {
    private static final long serialVersionUID = 10200L;
    private ComponentKey componentKey;
    private Component component;

    public JRBaseComponentElement(JRComponentElement element, JRBaseObjectFactory factory) {
        super(element, factory);
        this.componentKey = element.getComponentKey();
        ComponentManager manager = ComponentsEnvironment.getComponentManager(this.componentKey);
        this.component = manager.getComponentCompiler().toCompiledComponent(element.getComponent(), factory);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public ComponentKey getComponentKey() {
        return this.componentKey;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        ComponentManager manager = ComponentsEnvironment.getComponentManager(this.componentKey);
        manager.getComponentCompiler().collectExpressions(this.component, collector);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
    }
}

