/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.IndexedDataSource;

public class SortedDataSource
implements JRRewindableDataSource,
IndexedDataSource {
    private final List<SortRecord> records;
    private final Integer[] recordIndexes;
    private final Map<String, Integer> columnNamesMap = new HashMap<String, Integer>();
    private int currentIndex;
    private SortRecord currentRecord;

    public SortedDataSource(List<SortRecord> records, Integer[] recordIndexes, String[] columnNames) {
        if (records.size() != recordIndexes.length) {
            throw new IllegalArgumentException("Record count " + records.size() + " doesn't match index count " + recordIndexes.length);
        }
        this.records = records;
        this.recordIndexes = recordIndexes;
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNamesMap.put(columnNames[i], i);
            }
        }
        this.currentIndex = 0;
    }

    @Override
    public boolean next() {
        if (this.currentIndex >= this.recordIndexes.length) {
            return false;
        }
        int recordIndex = this.recordIndexes[this.currentIndex];
        this.currentRecord = this.records.get(recordIndex);
        ++this.currentIndex;
        return true;
    }

    public void setRecordFilteredIndex(int index) {
        this.currentRecord.markFiltered();
        this.currentRecord.setRecordIndex(index);
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.columnNamesMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException("Field \"" + jrField.getName() + "\" not found in data source.");
        }
        return this.currentRecord.fieldValue(fieldIndex);
    }

    @Override
    public void moveFirst() {
        this.currentIndex = 0;
    }

    @Override
    public int getRecordIndex() {
        return this.currentRecord.getRecordIndex();
    }

    public List<SortRecord> getRecords() {
        return this.records;
    }

    public static class SortRecord {
        private final Object[] values;
        private int recordIndex;
        private boolean filtered;

        public SortRecord(Object[] values, int recordIndex) {
            this.values = values;
            this.recordIndex = recordIndex;
            this.filtered = false;
        }

        protected void markFiltered() {
            this.filtered = true;
        }

        public Object fieldValue(int fieldIdx) {
            return this.values[fieldIdx];
        }

        public Object[] getValues() {
            return this.values;
        }

        protected void setRecordIndex(int recordIndex) {
            this.recordIndex = recordIndex;
        }

        public int getRecordIndex() {
            return this.recordIndex;
        }

        public boolean isFiltered() {
            return this.filtered;
        }
    }
}

