/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;
import net.sf.jasperreports.engine.util.JRQueryParser;

public abstract class JRAbstractQueryExecuter
implements JRQueryExecuter {
    protected static final int CLAUSE_POSITION_ID = 0;
    protected final Map<String, JRClauseFunction> clauseFunctions = new HashMap<String, JRClauseFunction>();
    private final JasperReportsContext jasperReportsContext;
    private final JRPropertiesUtil propertiesUtil;
    protected final JRDataset dataset;
    private final Map<String, ? extends JRValueParameter> parametersMap;
    private String queryString;
    private List<QueryParameter> queryParameters;
    private Set<String> parameterClauseStack;

    protected JRAbstractQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this.jasperReportsContext = jasperReportsContext;
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.dataset = dataset;
        this.parametersMap = parametersMap;
        this.queryString = "";
        this.queryParameters = new ArrayList<QueryParameter>();
    }

    protected JRAbstractQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    protected JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    protected JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    protected void registerClauseFunction(String id, JRClauseFunction function) {
        this.clauseFunctions.put(id, function);
    }

    protected void unregisterClauseFunction(String id) {
        this.clauseFunctions.remove(id);
    }

    protected JRClauseFunction resolveFunction(String id) {
        JRClauseFunction function = this.clauseFunctions.get(id);
        if (function == null) {
            throw new JRRuntimeException("No clause function for id " + id + " found");
        }
        return function;
    }

    protected void parseQuery() {
        JRQueryChunk[] chunks;
        this.parameterClauseStack = new HashSet<String>();
        JRQuery query = this.dataset.getQuery();
        if (query != null && (chunks = query.getChunks()) != null && chunks.length > 0) {
            StringBuffer sbuffer = new StringBuffer();
            for (int i = 0; i < chunks.length; ++i) {
                JRQueryChunk chunk = chunks[i];
                this.appendQueryChunk(sbuffer, chunk);
            }
            this.queryString = sbuffer.toString();
        }
    }

    protected void appendQueryChunk(StringBuffer sbuffer, JRQueryChunk chunk) {
        switch (chunk.getType()) {
            case 3: {
                this.appendParameterClauseChunk(sbuffer, chunk.getText());
                break;
            }
            case 2: {
                this.appendParameterChunk(sbuffer, chunk.getText());
                break;
            }
            case 4: {
                this.appendClauseChunk(sbuffer, chunk.getTokens());
                break;
            }
            default: {
                this.appendTextChunk(sbuffer, chunk.getText());
            }
        }
    }

    protected void appendTextChunk(StringBuffer sbuffer, String text) {
        sbuffer.append(text);
    }

    protected void appendParameterChunk(StringBuffer sbuffer, String chunkText) {
        String parameterName = chunkText;
        this.checkParameter(parameterName);
        sbuffer.append(this.getParameterReplacement(parameterName));
        this.addQueryParameter(chunkText);
    }

    protected void addQueryParameter(String parameterName) {
        QueryParameter param = new QueryParameter(parameterName);
        this.queryParameters.add(param);
    }

    protected void addQueryMultiParameters(String parameterName, int count) {
        QueryParameter param = new QueryParameter(parameterName, count);
        this.queryParameters.add(param);
    }

    protected void addQueryMultiParameters(String parameterName, int count, boolean ignoreNulls) {
        QueryParameter param = new QueryParameter(parameterName, count, ignoreNulls);
        this.queryParameters.add(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendParameterClauseChunk(final StringBuffer sbuffer, String chunkText) {
        String parameterName = chunkText;
        this.checkParameter(parameterName);
        if (!this.parameterClauseStack.add(parameterName)) {
            throw new JRRuntimeException("The query contains circularly nested parameter clauses starting with " + parameterName);
        }
        try {
            Object parameterValue = this.getParameterValue(parameterName);
            String clauseText = String.valueOf(parameterValue);
            JRQueryChunkHandler nestedChunkHandler = new JRQueryChunkHandler(){

                @Override
                public void handleParameterChunk(String text) {
                    JRAbstractQueryExecuter.this.appendParameterChunk(sbuffer, text);
                }

                @Override
                public void handleParameterClauseChunk(String text) {
                    JRAbstractQueryExecuter.this.appendParameterClauseChunk(sbuffer, text);
                }

                @Override
                public void handleTextChunk(String text) {
                    JRAbstractQueryExecuter.this.appendTextChunk(sbuffer, text);
                }

                @Override
                public void handleClauseChunk(String[] tokens) {
                    JRAbstractQueryExecuter.this.appendClauseChunk(sbuffer, tokens);
                }
            };
            JRQueryParser.instance().parse(clauseText, nestedChunkHandler);
        }
        finally {
            this.parameterClauseStack.remove(parameterName);
        }
    }

    protected void appendClauseChunk(StringBuffer sbuffer, String[] clauseTokens) {
        JRClauseTokens tokens = new JRClauseTokens(clauseTokens);
        String id = tokens.getToken(0);
        if (id == null) {
            throw new JRRuntimeException("Query clause ID/first token missing");
        }
        JRClauseFunction function = this.resolveFunction(id);
        this.applyClause(function, tokens, sbuffer);
    }

    protected void applyClause(JRClauseFunction function, JRClauseTokens tokens, final StringBuffer sbuffer) {
        function.apply(tokens, new JRQueryClauseContext(){

            @Override
            public void addQueryMultiParameters(String parameterName, int count) {
                this.addQueryMultiParameters(parameterName, count, false);
            }

            @Override
            public void addQueryMultiParameters(String parameterName, int count, boolean ignoreNulls) {
                JRAbstractQueryExecuter.this.addQueryMultiParameters(parameterName, count, ignoreNulls);
            }

            @Override
            public void addQueryParameter(String parameterName) {
                JRAbstractQueryExecuter.this.addQueryParameter(parameterName);
            }

            @Override
            public JRValueParameter getValueParameter(String parameterName) {
                return JRAbstractQueryExecuter.this.getValueParameter(parameterName);
            }

            @Override
            public StringBuffer queryBuffer() {
                return sbuffer;
            }
        });
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected List<String> getCollectedParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.queryParameters.size());
        for (QueryParameter param : this.queryParameters) {
            parameterNames.add(param.getName());
        }
        return parameterNames;
    }

    protected List<QueryParameter> getCollectedParameters() {
        return this.queryParameters;
    }

    protected Object getParameterValue(String parameterName, boolean ignoreMissing) {
        if (ignoreMissing) {
            JRValueParameter parameter = this.getValueParameter("REPORT_PARAMETERS_MAP", false);
            Map parametersMap = (Map)parameter.getValue();
            return parametersMap.get(parameterName);
        }
        JRValueParameter parameter = this.getValueParameter(parameterName, ignoreMissing);
        return parameter == null ? null : parameter.getValue();
    }

    protected Object getParameterValue(String parameterName) {
        return this.getParameterValue(parameterName, false);
    }

    protected boolean parameterHasValue(String parameter) {
        JRValueParameter reportParametersMap = this.getValueParameter("REPORT_PARAMETERS_MAP", false);
        Map parametersMap = (Map)reportParametersMap.getValue();
        return parametersMap.containsKey(parameter);
    }

    protected String getStringParameter(String parameter, String property) {
        if (this.parameterHasValue(parameter)) {
            return (String)this.getParameterValue(parameter, true);
        }
        return this.getPropertiesUtil().getProperty(this.dataset.getPropertiesMap(), property);
    }

    protected String getStringParameterOrProperty(String name) {
        return this.getStringParameter(name, name);
    }

    protected boolean getBooleanParameter(String parameter, String property, boolean defaultValue) {
        if (this.parameterHasValue(parameter)) {
            Boolean booleanValue = (Boolean)this.getParameterValue(parameter, true);
            if (booleanValue == null) {
                return this.getPropertiesUtil().getBooleanProperty(property);
            }
            return booleanValue;
        }
        return this.getPropertiesUtil().getBooleanProperty(this.dataset.getPropertiesMap(), property, defaultValue);
    }

    protected boolean getBooleanParameterOrProperty(String name, boolean defaultValue) {
        return this.getBooleanParameter(name, name, defaultValue);
    }

    protected JRFillParameter getParameter(String parameterName) {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter == null) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        return parameter;
    }

    protected void checkParameter(String parameterName) {
        if (!this.parametersMap.containsKey(parameterName)) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
    }

    protected JRValueParameter getValueParameter(String parameterName, boolean ignoreMissing) {
        JRValueParameter parameter = this.parametersMap.get(parameterName);
        if (parameter == null && !ignoreMissing) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        return parameter;
    }

    protected JRValueParameter getValueParameter(String parameterName) {
        return this.getValueParameter(parameterName, false);
    }

    protected abstract String getParameterReplacement(String var1);

    protected static class QueryParameter {
        protected static final int COUNT_SINGLE = -1;
        private final String name;
        private final int count;
        private final boolean ignoreNulls;

        public QueryParameter(String name) {
            this(name, -1, false);
        }

        public QueryParameter(String name, int count) {
            this(name, count, false);
        }

        public QueryParameter(String name, int count, boolean ignoreNulls) {
            this.name = name;
            this.count = count;
            this.ignoreNulls = ignoreNulls;
        }

        public boolean isMulti() {
            return this.count != -1;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }
    }
}

