/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.ReportContext;

public class WebReportContext
implements ReportContext {
    private static final String SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX = "net.sf.jasperreports.web.report.context_";
    public static final String REQUEST_PARAMETER_REPORT_CONTEXT_ID = "jr.ctxid";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT = "net.sf.jasperreports.web.jasper_print";
    public static final String REPORT_CONTEXT_PARAMETER_JASPER_PRINT_ACCESSOR = "net.sf.jasperreports.web.jasper_print.accessor";
    private Map<String, String> requestParameters = new HashMap<String, String>();
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private String id;

    public static final WebReportContext getInstance(HttpServletRequest request) {
        return WebReportContext.getInstance(request, true);
    }

    public static final WebReportContext getInstance(HttpServletRequest request, boolean create) {
        WebReportContext webReportContext = null;
        String reportContextId = request.getParameter(REQUEST_PARAMETER_REPORT_CONTEXT_ID);
        if (reportContextId != null) {
            webReportContext = (WebReportContext)request.getSession().getAttribute(WebReportContext.getSessionAttributeName(reportContextId));
        }
        if (webReportContext == null && create) {
            webReportContext = new WebReportContext();
            request.getSession().setAttribute(webReportContext.getSessionAttributeName(), (Object)webReportContext);
        }
        if (webReportContext != null) {
            webReportContext.setParameterValue("net.sf.jasperreports.web.app.context.path", request.getContextPath());
            webReportContext.setParameterValue("REPORT_CONTEXT", webReportContext);
        }
        return webReportContext;
    }

    private WebReportContext() {
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = String.valueOf(System.currentTimeMillis());
        }
        return this.id;
    }

    public String getSessionAttributeName() {
        return WebReportContext.getSessionAttributeName(this.getId());
    }

    @Override
    public Object getParameterValue(String parameterName) {
        String requestParameterValue = this.requestParameters.get(parameterName);
        if (requestParameterValue != null) {
            return requestParameterValue;
        }
        return this.parameterValues.get(parameterName);
    }

    @Override
    public boolean containsParameter(String parameterName) {
        String requestParameterValue = this.requestParameters.get(parameterName);
        if (requestParameterValue != null) {
            return true;
        }
        return this.parameterValues.containsKey(parameterName);
    }

    @Override
    public void setParameterValue(String parameterName, Object value) {
        this.parameterValues.put(parameterName, value);
    }

    public void setParameterValues(Map<String, Object> newValues) {
        this.parameterValues.putAll(newValues);
    }

    public Map<String, Object> getParameterValues() {
        return this.parameterValues;
    }

    private static final String getSessionAttributeName(String id) {
        return SESSION_ATTRIBUTE_REPORT_CONTEXT_ID_PREFIX + id;
    }
}

