/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RepositorySearchCriteriaImpl
implements RepositorySearchCriteria {
    private SearchMode searchMode;
    private String sortBy;
    private int startIndex;
    private int maxCount;
    private String searchText;
    private String folderUri;
    private List<String> resourceTypes;
    private List<SearchFilter> customFilters;

    @Override
    public List<SearchFilter> getCustomFilters() {
        return this.customFilters;
    }

    @Override
    public void setCustomFilters(List<SearchFilter> customFilters) {
        this.customFilters = customFilters;
    }

    @Override
    public void addCustomFilter(SearchFilter customFilter) {
        if (this.customFilters == null) {
            this.customFilters = new ArrayList<SearchFilter>();
        }
        this.customFilters.add(customFilter);
    }

    @Override
    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    @Override
    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    @Override
    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public String getSearchText() {
        return this.searchText;
    }

    @Override
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Override
    public String getFolderUri() {
        return this.folderUri;
    }

    @Override
    public void setFolderUri(String folderUri) {
        this.folderUri = folderUri;
    }

    @Override
    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    @Override
    public void setResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public static class Builder {
        private final RepositorySearchCriteria criteria = new RepositorySearchCriteriaImpl();

        public Builder setSearchMode(SearchMode searchMode) {
            this.criteria.setSearchMode(searchMode);
            return this;
        }

        public Builder setSortBy(String sortBy) {
            this.criteria.setSortBy(sortBy);
            return this;
        }

        public Builder setStartIndex(int currentIndex) {
            this.criteria.setStartIndex(currentIndex);
            return this;
        }

        public Builder setMaxCount(int maxCount) {
            this.criteria.setMaxCount(maxCount);
            return this;
        }

        public Builder setSearchText(String searchText) {
            this.criteria.setSearchText(searchText);
            return this;
        }

        public Builder setFolderUri(String folderUri) {
            this.criteria.setFolderUri(folderUri);
            return this;
        }

        public Builder setResourceTypes(List<String> resourceTypes) {
            this.criteria.setResourceTypes(resourceTypes);
            return this;
        }

        public Builder setResourceTypes(String ... resourceTypes) {
            this.criteria.setResourceTypes(new ArrayList<String>(Arrays.asList(resourceTypes)));
            return this;
        }

        public Builder setCustomFilters(List<SearchFilter> customFilters) {
            this.criteria.setCustomFilters(customFilters);
            return this;
        }

        public RepositorySearchCriteria getCriteria() {
            return this.criteria;
        }
    }
}

