/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    private JSONUtil() {
    }

    public static void applyFunctorToJson(Object jsonElem, Functor functor) {
        JSONUtil.applyFunctorToJsonRecursively(jsonElem, null, functor);
    }

    private static void applyFunctorToJsonRecursively(Object jsonElem, String jsonElemKey, Functor functor) {
        block10: {
            try {
                if (jsonElem == null) {
                    return;
                }
                if (jsonElem instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)jsonElem;
                    for (int j = 0; j < jsonArray.length(); ++j) {
                        Object elem = jsonArray.get(j);
                        if (elem instanceof JSONObject) {
                            JSONUtil.applyFunctorToJsonRecursively(elem, null, functor);
                            continue;
                        }
                        if (elem instanceof JSONArray) {
                            JSONUtil.applyFunctorToJsonRecursively(elem, jsonElemKey, functor);
                            continue;
                        }
                        Object procVal = functor.call(jsonElemKey, elem.toString());
                        if (procVal == null) continue;
                        jsonArray.put(j, procVal);
                    }
                    break block10;
                }
                if (jsonElem instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)jsonElem;
                    Iterator iter = jsonObject.keys();
                    while (iter.hasNext()) {
                        String childElemKey = (String)iter.next();
                        Object childElemVal = jsonObject.get(childElemKey);
                        if (childElemVal instanceof JSONObject || childElemVal instanceof JSONArray) {
                            JSONUtil.applyFunctorToJsonRecursively(childElemVal, childElemKey, functor);
                            continue;
                        }
                        Object procVal = functor.call(childElemKey, childElemVal.toString());
                        if (procVal == null) continue;
                        ((JSONObject)jsonElem).put(childElemKey, procVal);
                    }
                    break block10;
                }
                return;
            }
            catch (JSONException je) {
                throw new RuntimeException("Exception during applying functor to JSON.", je);
            }
        }
    }

    public static JSONObject getJSONObject(String maybeJsonStr) {
        try {
            return new JSONObject(maybeJsonStr);
        }
        catch (Exception e1) {
            return null;
        }
    }

    public static JSONArray getJSONArray(String maybeJsonStr) {
        try {
            return new JSONArray(maybeJsonStr);
        }
        catch (Exception e1) {
            return null;
        }
    }

    public static interface Functor {
        public Object call(String var1, String var2);
    }
}

