/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.client;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import java.util.Date;
import java.util.List;

public class ResourceLookupImpl
implements ResourceLookup {
    private int version;
    private Date creationDate;
    private Date updateDate;
    private String name;
    private String label;
    private String description;
    private String folderUri;
    private String uri;
    private String resourceType;
    private List attributes = null;

    private static String getParentFolderFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == 0) {
            return "/";
        }
        return s.substring(0, lastSeparator);
    }

    private static String getNameFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator < 0 || lastSeparator == s.length() - 1) {
            return null;
        }
        return s.substring(lastSeparator + 1, s.length());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setName(String name) {
        this.uri = null;
        this.name = name;
    }

    @Override
    public String getURIString() {
        if (this.uri == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getParentFolder() != null && !this.getParentFolder().equals("/")) {
                sb.append(this.getParentFolder());
            }
            sb.append("/");
            if (!this.getName().equals("/")) {
                sb.append(this.getName());
            }
            this.uri = sb.toString();
        }
        return this.uri;
    }

    @Override
    public String getURI() {
        return this.getProtocol() + ":" + this.getPath();
    }

    @Override
    public String getParentURI() {
        return this.getParentFolder() == null ? null : this.getProtocol() + ":" + this.getParentFolder();
    }

    @Override
    public String getParentPath() {
        return this.getParentFolder() == null ? null : this.getParentFolder();
    }

    @Override
    public String getPath() {
        return this.getURIString();
    }

    @Override
    public String getProtocol() {
        return "repo";
    }

    @Override
    public String getParentFolder() {
        return this.folderUri;
    }

    @Override
    public void setParentFolder(Folder folder) {
        this.uri = null;
        this.folderUri = folder.getURIString();
    }

    @Override
    public void setParentFolder(String folderURI) {
        this.uri = null;
        this.folderUri = folderURI;
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    protected final JSException lookupUnsupportedException() {
        return new JSException("jsexception.call.not.supported");
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public void setURIString(String uri) {
        this.uri = null;
        this.name = ResourceLookupImpl.getNameFromUri(uri);
        this.folderUri = ResourceLookupImpl.getParentFolderFromUri(uri);
    }

    @Override
    public boolean isSameType(Resource resource) {
        return this.getResourceType().equals(resource.getResourceType());
    }
}

