/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FileResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementDisjunction;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.model.impl.TypedTreeDataProvider;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class FileResourceAction
extends FormAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String FORM_OBJECT_KEY = "fileResource";
    protected static final String FILE_RESOURCE_COPY = "fileResourceCopy";
    private static final String FILERES_URI_PARAM = "resource";
    protected static final String PARENT_FOLDER_ATTR = "parentFolder";
    protected static final String CONSTANTS_KEY = "constants";
    private static final String ATTRIBUTE_ORGANIZATION_ID = "organizationId";
    private static final String ATTRIBUTE_PUBLIC_FOLDER_URI = "publicFolderUri";
    private static final String ATTRIBUTE_ALL_FILE_TYPES = "allTypes";
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String FILE_RESOURCE_TREE_DATA_PROVIDER = "fileResourceTreeDataProvider";
    private String expectedFileTypeParameter = "expectedFileType";
    private String expectedFileTypeAttribute = "expectedFileType";
    protected RepositoryService repository;
    private ConfigurationBean configuration;
    protected MessageSource messages;
    private SecurityContextProvider securityContextProvider;
    private TypedTreeDataProvider typedTreeDataProvider;

    public FileResourceAction() {
        this.setFormObjectClass(FileResourceWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public Event initAction(RequestContext context) throws Exception {
        String folderURI;
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.isSubflowMode()) {
            FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
            if (wrapper.getFileResource().getFileType() != null && wrapper.getFileResource().getFileType().trim().length() != 0) {
                criteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)wrapper.getFileResource().getFileType()));
            } else if (this.isMasterFlowReportUnit(context)) {
                FilterElementDisjunction olapTypesFilter = new FilterElementDisjunction();
                olapTypesFilter.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"olapMondrianSchema"));
                olapTypesFilter.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"accessGrantSchema"));
                criteria.addNegatedFilterElement((FilterElement)olapTypesFilter);
            }
            ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
            ArrayList<String> allResources = null;
            if (lookups != null && lookups.length != 0) {
                allResources = new ArrayList<String>();
                this.log("Found lookups size=" + lookups.length);
                for (int i = 0; i < lookups.length; ++i) {
                    allResources.add(lookups[i].getURIString());
                }
            }
            wrapper.setAllResources(allResources);
        }
        if (wrapper.isNewMode()) {
            folderURI = wrapper.getFileResource().getParentFolder();
            if (folderURI == null) {
                folderURI = "/";
            }
            FilterCriteria resourcesInFolder = FilterCriteria.createFilter();
            resourcesInFolder.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            this.log("Searching for resources in the chosen folder:" + folderURI);
            ResourceLookup[] existingResources = this.repository.findResource(null, resourcesInFolder);
            if (existingResources != null && existingResources.length != 0) {
                this.log("res lookup size=" + existingResources.length);
                ArrayList<String> allResources = new ArrayList<String>();
                for (int i = 0; i < existingResources.length; ++i) {
                    ResourceLookup rLookup = existingResources[i];
                    allResources.add(rLookup.getName());
                    this.log("adding resource: " + rLookup.getName() + " to the list");
                }
                wrapper.setExistingResources(allResources);
            }
        }
        if (wrapper.isSubflowMode()) {
            this.getAllFolders(wrapper);
            folderURI = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (folderURI == null) {
                folderURI = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)folderURI);
            }
            if (folderURI == null) {
                folderURI = "/";
            }
            if (!this.isMasterFlowReportUnit(context)) {
                wrapper.getFileResource().setParentFolder(folderURI);
            }
        }
        if (wrapper.getSource() == null) {
            if (wrapper.isNewMode()) {
                wrapper.setSource("FILE_SYSTEM");
            } else if (wrapper.getFileResource() != null) {
                wrapper.setSource("CONTENT_REPOSITORY");
                wrapper.setNewUri(wrapper.getFileResource().getReferenceURI());
            }
        }
        context.getFlowScope().put(FORM_OBJECT_KEY, (Object)wrapper);
        context.getFlowScope().put(CONSTANTS_KEY, (Object)new JasperServerConstImpl());
        String expectedFileType = context.getRequestParameters().get(this.expectedFileTypeParameter);
        if (expectedFileType == null && wrapper.getFileResource().getFileType() != null) {
            expectedFileType = wrapper.getFileResource().getFileType();
        }
        context.getFlowScope().put(this.expectedFileTypeAttribute, (Object)expectedFileType);
        context.getFlowScope().put(FILE_RESOURCE_COPY, (Object)new FileResourceImpl((FileResourceImpl)wrapper.getFileResource()));
        context.getFlowScope().put(ATTRIBUTE_ORGANIZATION_ID, (Object)this.securityContextProvider.getContextUser().getTenantId());
        context.getFlowScope().put(ATTRIBUTE_PUBLIC_FOLDER_URI, (Object)this.configuration.getPublicFolderUri());
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        context.getFlowScope().put(ATTRIBUTE_ALL_FILE_TYPES, (Object)this.configuration.getAllFileResourceTypes());
        context.getExternalContext().getSessionMap().put(FILE_RESOURCE_TREE_DATA_PROVIDER, (Object)this.typedTreeDataProvider);
        return this.success();
    }

    protected void getAllFolders(FileResourceWrapper wrapper) {
        List allFolders = this.repository.getAllFolders(null);
        wrapper.setAllFolders(new ArrayList());
        for (int i = 0; i < allFolders.size(); ++i) {
            String folderUri = ((Folder)allFolders.get(i)).getURIString();
            wrapper.getAllFolders().add(folderUri);
        }
    }

    public Event determineType(RequestContext context) throws Exception {
        String fileExtension;
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.getFileResource().getFileType() == null && (fileExtension = context.getExternalContext().getRequestMap().getString("uploadedFileExt")) != null && fileExtension.trim().length() != 0) {
            wrapper.getFileResource().setFileType(this.getTypeForExtension(context, fileExtension));
        }
        if (wrapper.getSource() != null && wrapper.getSource().equals("CONTENT_REPOSITORY")) {
            String newUri = wrapper.getNewUri();
            if (newUri != null && newUri.trim().length() != 0) {
                Resource resource = this.repository.getResource(null, newUri);
                if (FileResource.class.isAssignableFrom(resource.getClass())) {
                    FileResource fileR = (FileResource)resource;
                    wrapper.getFileResource().setFileType(fileR.getFileType());
                }
                if ("olapMondrianSchema".equals(wrapper.getFileResource().getFileType()) || "accessGrantSchema".equals(wrapper.getFileResource().getFileType())) {
                    ((FileResource)resource).setReferenceURI(wrapper.getFileResource().getReferenceURI());
                    wrapper.setFileResource((FileResource)resource);
                }
            }
            wrapper.setLocated(true);
        }
        if (wrapper.getSource() != null) {
            if (wrapper.getSource().equals("FILE_SYSTEM")) {
                wrapper.setNewUri(null);
                wrapper.setLocated(true);
            } else if (wrapper.getSource().equals("NONE")) {
                return this.no();
            }
        }
        return this.success();
    }

    protected String getTypeForExtension(RequestContext context, String extension) {
        String type = null;
        if (extension != null) {
            if (extension.equalsIgnoreCase("jrxml")) {
                type = "jrxml";
            } else if (extension.equalsIgnoreCase("ttf")) {
                type = "font";
            } else if (extension.equalsIgnoreCase("xml")) {
                type = this.determineXmlResourceType(context);
            } else if (extension.equalsIgnoreCase("agxml")) {
                type = "accessGrantSchema";
            } else if (extension.equalsIgnoreCase("jar")) {
                type = "jar";
            } else if (extension.indexOf("prop") != -1) {
                type = "prop";
            } else if (extension.equalsIgnoreCase("jrtx")) {
                type = "jrtx";
            } else {
                String[] imageTypes = new String[]{"jpg", "jpeg", "gif", "bmp"};
                for (int i = 0; i < imageTypes.length; ++i) {
                    if (!extension.equalsIgnoreCase(imageTypes[i])) continue;
                    type = "img";
                }
            }
        }
        return type;
    }

    protected String determineXmlResourceType(RequestContext context) {
        String expectedType = (String)context.getFlowScope().get(this.expectedFileTypeAttribute);
        String type = expectedType != null && "xml".equals(expectedType) ? "xml" : "olapMondrianSchema";
        return type;
    }

    protected boolean isMasterFlowReportUnit(RequestContext context) {
        String masterFlow = context.getFlowScope().getString("masterFlow");
        return "reportUnit".equals(masterFlow);
    }

    public Event setupNamingForm(RequestContext context) throws Exception {
        context.getRequestScope().put(ATTRIBUTE_ALL_FILE_TYPES, (Object)this.configuration.getAllFileResourceTypes());
        return this.success();
    }

    public Event cancelFileResourceChanges(RequestContext context) throws Exception {
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        FileResourceImpl file = (FileResourceImpl)context.getFlowScope().get(FILE_RESOURCE_COPY);
        wrapper.setFileResource((FileResource)new FileResourceImpl(file));
        wrapper.setLocated(false);
        return this.success();
    }

    public Event saveResource(RequestContext context) throws Exception {
        this.log("In saveresource");
        FileResourceWrapper wrapper = (FileResourceWrapper)this.getFormObject(context);
        if (wrapper.getFileResource().getParentFolder() == null) {
            wrapper.getFileResource().setParentFolder("/");
        }
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getFileResource());
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("fileResource.name", "FileResourceValidator.error.duplicate");
                return this.error();
            }
            if (!wrapper.isEditMode()) {
                context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.file.fileAdded", (Object[])new String[]{wrapper.getFileResource().getName(), wrapper.getFileResource().getParentFolder()}, LocaleContextHolder.getLocale()));
            }
            return this.yes();
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        FileResourceWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get(FILERES_URI_PARAM);
        if (resourceUri == null) {
            resourceUri = context.getRequestParameters().get("selectedResource");
        }
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            Resource resource = this.repository.getResource(null, resourceUri);
            if (resource == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new FileResourceWrapper();
            formObject.setFileResource((FileResource)resource);
            formObject.setMode((byte)2);
            formObject.setLocated(true);
        }
        if (formObject == null) {
            formObject = new FileResourceWrapper();
            formObject.setMode((byte)1);
            String parentFolder = context.getRequestParameters().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            FileResource fileResource = (FileResource)this.repository.newResource(null, FileResource.class);
            fileResource.setParentFolder(parentFolder);
            fileResource.setVersion(-1);
            formObject.setFileResource(fileResource);
        }
        return formObject;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public String getExpectedFileTypeParameter() {
        return this.expectedFileTypeParameter;
    }

    public void setExpectedFileTypeParameter(String expectedFileTypeParameter) {
        this.expectedFileTypeParameter = expectedFileTypeParameter;
    }

    public String getExpectedFileTypeAttribute() {
        return this.expectedFileTypeAttribute;
    }

    public void setExpectedFileTypeAttribute(String expectedFileTypeAttribute) {
        this.expectedFileTypeAttribute = expectedFileTypeAttribute;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    protected void log(String text) {
        this.log.debug((Object)text);
    }

    public static String getFORM_OBJECT_KEY() {
        return FORM_OBJECT_KEY;
    }

    protected void doBind(RequestContext context, DataBinder binder) throws Exception {
        super.doBind(context, binder);
        FileResourceWrapper res = (FileResourceWrapper)binder.getTarget();
        res.afterBind();
    }

    public void setFileResourceTreeDataProvider(TypedTreeDataProvider typedTreeDataProvider) {
        this.typedTreeDataProvider = typedTreeDataProvider;
    }
}

