/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSShowOnlyErrorMessage;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.war.action.ReportExecutionAttributes;
import com.jaspersoft.jasperserver.war.action.ViewReportAction;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;

public class ReportExecutionController
extends MultiActionController {
    private static final Log log = LogFactory.getLog(ViewReportAction.class);
    public static final String REPORT_EXECUTION_PREFIX = "flowReportExecution";
    public static final String REPORT_EXECUTION_ID_PREFIX = "flowReportExecutionId";
    private static final View NULL_VIEW = new View(){

        public String getContentType() {
            return null;
        }

        public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    };
    private EngineService engineService;
    private SessionObjectSerieAccessor jasperPrintAccessor;
    private DataCacheProvider dataCacheProvider;

    public ModelAndView viewReportCancel(HttpServletRequest req, HttpServletResponse res) {
        String flowExecutionKey = req.getParameter("_flowExecutionKey");
        String sessionName = REPORT_EXECUTION_PREFIX + flowExecutionKey;
        ReportExecutionAttributes execution = (ReportExecutionAttributes)req.getSession().getAttribute(sessionName);
        if (execution == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No report execution to cancel");
            }
        } else {
            boolean canceled = this.engineService.cancelExecution(execution.getRequestId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Report execution " + execution.getRequestId() + " cancel status: " + canceled));
            }
        }
        return new ModelAndView(NULL_VIEW);
    }

    public ModelAndView viewReportAsyncCancel(HttpServletRequest req, HttpServletResponse res) throws Exception {
        ReportUnitResult result = this.getReportResult(req);
        String requestId = result == null ? null : result.getRequestId();
        LinkedHashMap<String, Object> actionResult = new LinkedHashMap<String, Object>();
        if (requestId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No async report execution to cancel");
            }
        } else {
            boolean canceled = this.engineService.cancelExecution(requestId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Report execution " + requestId + " cancel status: " + canceled));
            }
            JasperPrintAccessor resultPrintAccessor = result.getJasperPrintAccessor();
            try {
                resultPrintAccessor.getFinalJasperPrint();
            }
            catch (JRRuntimeException e) {
                // empty catch block
            }
            this.putReportStatusResult(res, result, actionResult);
        }
        return new ModelAndView("json:result", Collections.singletonMap("result", actionResult));
    }

    protected ReportUnitResult getReportResult(HttpServletRequest req) {
        String jasperPrintName = req.getParameter("jasperPrintName");
        ReportUnitResult result = (ReportUnitResult)this.getJasperPrintAccessor().getObject(req, jasperPrintName);
        return result;
    }

    public ModelAndView viewReportPageUpdateCheck(HttpServletRequest req, HttpServletResponse res) throws Exception {
        Long pageTimestamp;
        JasperPrintAccessor printAccessor;
        ReportUnitResult reportResult = this.getReportResult(req);
        JasperPrintAccessor jasperPrintAccessor = printAccessor = reportResult == null ? null : reportResult.getJasperPrintAccessor();
        if (printAccessor == null) {
            return null;
        }
        String pageIdxParam = req.getParameter("pageIndex");
        Integer pageIndex = pageIdxParam == null ? null : Integer.valueOf(pageIdxParam);
        String pageTimestampParam = req.getParameter("pageTimestamp");
        Long l = pageTimestamp = pageTimestampParam == null ? null : Long.valueOf(pageTimestampParam);
        if (log.isDebugEnabled()) {
            log.debug((Object)("report page update check for " + reportResult.getRequestId() + ", pageIndex: " + pageIndex + ", pageTimestamp: " + pageTimestamp));
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.putReportStatusResult(res, reportResult, result);
        if (pageIndex != null && pageTimestamp != null) {
            ReportPageStatus pageStatus = printAccessor.pageStatus(pageIndex.intValue(), pageTimestamp);
            boolean modified = pageStatus.hasModified();
            result.put("pageModified", modified);
            if (log.isDebugEnabled()) {
                log.debug((Object)("page modified " + modified));
            }
        }
        return new ModelAndView("json:result", Collections.singletonMap("result", result));
    }

    protected void putReportStatusResult(HttpServletResponse res, ReportUnitResult reportResult, LinkedHashMap<String, Object> result) throws Exception {
        String status;
        JasperPrintAccessor printAccessor = reportResult.getJasperPrintAccessor();
        ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
        result.put("lastPartialPageIndex", reportStatus.getCurrentPageCount() - 1);
        switch (reportStatus.getStatus()) {
            case FINISHED: {
                status = "finished";
                Integer totalPageCount = reportStatus.getTotalPageCount();
                result.put("lastPageIndex", totalPageCount - 1);
                ReportContext reportContext = reportResult.getReportContext();
                DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
                if (snapshotSaveStatus != null) {
                    result.put("snapshotSaveStatus", snapshotSaveStatus.toString());
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("report finished " + totalPageCount + " pages; snapshot status " + snapshotSaveStatus));
                break;
            }
            case ERROR: {
                status = "error";
                this.handleReportUpdateError(res, reportStatus);
                break;
            }
            case CANCELED: {
                status = "canceled";
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"report canceled");
                break;
            }
            default: {
                status = "running";
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"report running");
            }
        }
        result.put("status", status);
    }

    protected void handleReportUpdateError(HttpServletResponse res, ReportExecutionStatus reportStatus) throws Exception {
        Throwable error = reportStatus.getError();
        if (log.isDebugEnabled()) {
            log.debug((Object)("report error " + error));
        }
        res.setHeader("reportError", "true");
        res.setHeader("lastPartialPageIndex", Integer.toString(reportStatus.getCurrentPageCount() - 1));
        if (error instanceof Exception) {
            int indexIO = ExceptionUtils.indexOfThrowable((Throwable)error, IOException.class);
            if (indexIO != -1) {
                Exception sourceException = (Exception)ExceptionUtils.getThrowableList((Throwable)error).get(indexIO);
                throw new JSShowOnlyErrorMessage(sourceException.getMessage());
            }
            throw (Exception)error;
        }
        throw new JSException("jsexception.view.report.error", error);
    }

    public EngineService getEngineService() {
        return this.engineService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public SessionObjectSerieAccessor getJasperPrintAccessor() {
        return this.jasperPrintAccessor;
    }

    public void setJasperPrintAccessor(SessionObjectSerieAccessor jasperPrintAccessor) {
        this.jasperPrintAccessor = jasperPrintAccessor;
    }

    public DataCacheProvider getDataCacheProvider() {
        return this.dataCacheProvider;
    }

    public void setDataCacheProvider(DataCacheProvider dataCacheProvider) {
        this.dataCacheProvider = dataCacheProvider;
    }
}

