/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade;

import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.cache.ControlLogicCacheManager;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CachedRepositoryService {
    private static final String URI_RESOURCE_TYPE_MAPPING_CACHE_KEY = "uriResourceTypeMapping";
    @Resource
    private ControlLogicCacheManager controlLogicCacheManager;
    @Resource(name="concreteRepository")
    private RepositoryService repositoryService;
    @Resource(name="inputControlsCachingEnabled")
    private boolean doCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Class<? super com.jaspersoft.jasperserver.api.metadata.common.domain.Resource>> getUriResourceTypeMapping() {
        SessionCache sessionCache = this.controlLogicCacheManager.getSessionCache();
        HashMap uriResourceTypeMapping = sessionCache.getCacheInfo(Map.class, URI_RESOURCE_TYPE_MAPPING_CACHE_KEY);
        if (uriResourceTypeMapping == null) {
            SessionCache sessionCache2 = sessionCache;
            synchronized (sessionCache2) {
                uriResourceTypeMapping = sessionCache.getCacheInfo(Map.class, URI_RESOURCE_TYPE_MAPPING_CACHE_KEY);
                if (uriResourceTypeMapping == null) {
                    uriResourceTypeMapping = new HashMap();
                    sessionCache.setCacheInfo(Map.class, URI_RESOURCE_TYPE_MAPPING_CACHE_KEY, uriResourceTypeMapping);
                }
            }
        }
        return uriResourceTypeMapping;
    }

    public <T> T getResource(Class<T> resourceType, ResourceReference reference) throws CascadeResourceNotFoundException {
        Object resource = null;
        if (reference != null) {
            resource = reference.isLocal() ? reference.getLocalResource() : this.getResource(resourceType, reference.getReferenceURI());
        }
        return (T)resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getResource(Class<T> resourceType, String resourceUri) throws CascadeResourceNotFoundException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource result;
        SessionCache sessionCache = this.controlLogicCacheManager.getSessionCache();
        Map<String, Class<? super com.jaspersoft.jasperserver.api.metadata.common.domain.Resource>> uriResourceTypeMapping = this.getUriResourceTypeMapping();
        Class<Object> concreteResourceType = uriResourceTypeMapping.get(resourceUri);
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = result = concreteResourceType != null && resourceType.isAssignableFrom(concreteResourceType) ? sessionCache.getCacheInfo(concreteResourceType, resourceUri) : null;
        if (!this.doCache || result == null) {
            SessionCache sessionCache2 = sessionCache;
            synchronized (sessionCache2) {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource2 = result = concreteResourceType != null && resourceType.isAssignableFrom(concreteResourceType) ? sessionCache.getCacheInfo(concreteResourceType, resourceUri) : null;
                if (result == null) {
                    com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource3 = this.repositoryService.getResource(ExecutionContextImpl.getRuntimeExecutionContext(), resourceUri);
                    if (resource3 == null || !resourceType.isAssignableFrom(resource3.getClass())) {
                        throw new CascadeResourceNotFoundException(resourceUri, resourceType.getName());
                    }
                    result = resource3;
                    if (concreteResourceType == null) {
                        try {
                            concreteResourceType = Class.forName(resource3.getResourceType());
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Resource type class not found", e);
                        }
                    }
                    sessionCache.setCacheInfo(concreteResourceType, resourceUri, resource3);
                    uriResourceTypeMapping.put(resourceUri, concreteResourceType);
                }
            }
        }
        return (T)result;
    }

    public ControlLogicCacheManager getControlLogicCacheManager() {
        return this.controlLogicCacheManager;
    }

    public void setControlLogicCacheManager(ControlLogicCacheManager controlLogicCacheManager) {
        this.controlLogicCacheManager = controlLogicCacheManager;
    }

    public boolean isDoCache() {
        return this.doCache;
    }

    public void setDoCache(boolean doCache) {
        this.doCache = doCache;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

