/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.cache;

import com.jaspersoft.jasperserver.war.cascade.cache.CacheCleaner;
import com.jaspersoft.jasperserver.war.cascade.cache.ControlLogicCacheManager;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCache;
import com.jaspersoft.jasperserver.war.cascade.cache.SessionCacheImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.request.RequestContextHolder;

public class ControlLogicCacheManagerImpl
implements ControlLogicCacheManager,
InitializingBean {
    private long cacheCleanTriggerTime = 300000L;
    private long userCacheTimeout = 120000L;
    private volatile Map<String, SessionCache> sessionCachePool = Collections.synchronizedMap(new HashMap());

    public void afterPropertiesSet() throws Exception {
        Timer cascadeCacheCleanerTimer = new Timer("CascadeCacheCleaner", true);
        CacheCleaner cacheCleanerTimerTask = new CacheCleaner(this.sessionCachePool, this.userCacheTimeout);
        cascadeCacheCleanerTimer.scheduleAtFixedRate((TimerTask)cacheCleanerTimerTask, this.cacheCleanTriggerTime, this.cacheCleanTriggerTime);
    }

    public void setCacheCleanTriggerTime(long cacheCleanTriggerTime) {
        this.cacheCleanTriggerTime = cacheCleanTriggerTime * 1000L;
    }

    public void setUserCacheTimeout(long userCacheTimeout) {
        this.userCacheTimeout = userCacheTimeout * 1000L;
    }

    @Override
    public void clearCache() {
        this.getSessionCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionCache getSessionCache() {
        String key;
        try {
            key = RequestContextHolder.currentRequestAttributes().getSessionId();
        }
        catch (IllegalStateException e) {
            key = "fakeSessionId";
        }
        SessionCache cache = this.sessionCachePool.get(key);
        if (cache == null) {
            Map<String, SessionCache> map = this.sessionCachePool;
            synchronized (map) {
                cache = this.sessionCachePool.get(key);
                if (cache == null) {
                    cache = new SessionCacheImpl();
                    this.sessionCachePool.put(key, cache);
                }
            }
        }
        return cache;
    }
}

