/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.GenericTypeProcessorRegistry;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DateParser;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.InputControlValueClassResolver;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="dataConverterService")
public class DataConverterServiceImpl
implements DataConverterService {
    @Resource
    protected CachedRepositoryService cachedRepositoryService;
    @Resource
    private GenericTypeProcessorRegistry genericTypeProcessorRegistry;
    @Resource
    protected MessageSource messageSource;

    private DataConverter<?> getDataConverter(Class<?> valueClass) {
        return this.genericTypeProcessorRegistry.getTypeProcessor(valueClass, DataConverter.class);
    }

    private DateParser<?> getDateParser(Class<?> valueClass) {
        return this.genericTypeProcessorRegistry.getTypeProcessor(valueClass, DateParser.class, false);
    }

    @Override
    public String formatSingleValue(Object typedValue, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        DataType dataType = this.getDataType(inputControl);
        return this.formatSingleValue(typedValue, dataType, InputControlValueClassResolver.getValueClass(dataType, info));
    }

    @Override
    public String formatSingleValue(Object typedValue, DataType dataType, Class<?> defaultClass) throws CascadeResourceNotFoundException {
        Class<?> valueClass = typedValue != null ? typedValue.getClass() : defaultClass;
        String result = dataType != null && 3 == dataType.getType() && this.getDateParser(valueClass) != null ? this.getDateParser(valueClass).dateToString(typedValue) : this.getDataConverter(valueClass).valueToString(typedValue);
        return result;
    }

    @Override
    public Object convertSingleValue(String rawValue, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException, InputControlValidationException {
        DataType dataType = this.getDataType(inputControl);
        return this.convertSingleValue(rawValue, dataType, InputControlValueClassResolver.getValueClass(dataType, info));
    }

    @Override
    public Object convertSingleValue(String rawValue, DataType dataType, Class<?> valueClass) throws CascadeResourceNotFoundException, InputControlValidationException {
        Object result;
        try {
            result = dataType != null && 3 == dataType.getType() && this.getDateParser(valueClass) != null ? this.getDateParser(valueClass).parsDate(rawValue) : this.getDataConverter(valueClass).stringToValue(rawValue);
        }
        catch (Exception e) {
            String className = valueClass.getSimpleName();
            String message = this.messageSource.getMessage("fillParameters.error.invalidValueForType", new Object[]{className}, LocaleContextHolder.getLocale());
            throw new InputControlValidationException("fillParameters.error.invalidValueForType", new Object[]{className}, message, rawValue);
        }
        return result;
    }

    private DataType getDataType(InputControl inputControl) throws CascadeResourceNotFoundException {
        return inputControl != null && inputControl.getDataType() != null ? this.cachedRepositoryService.getResource(DataType.class, inputControl.getDataType()) : null;
    }
}

