/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class DoubleDataConverter
implements DataConverter<Double> {
    @Override
    public Double stringToValue(String rawData) {
        return StringUtils.isNotEmpty((String)rawData) ? Double.valueOf(Double.parseDouble(rawData.replace(",", "."))) : null;
    }

    @Override
    public String valueToString(Double value) {
        if (value == null) {
            return "";
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(LocaleContextHolder.getLocale());
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(Integer.MAX_VALUE);
        return df.format(value);
    }
}

