/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.converters;

import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverter;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DateParser;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TimestampDataConverter
implements DataConverter<Timestamp>,
DateParser<Timestamp> {
    @Resource(name="messagesCalendarFormatProvider")
    protected CalendarFormatProvider calendarFormatProvider;

    @Override
    public Timestamp stringToValue(String rawData) throws ParseException {
        return StringUtils.isNotEmpty((String)rawData) ? new Timestamp(this.calendarFormatProvider.getDatetimeFormat().parse(rawData).getTime()) : null;
    }

    @Override
    public String valueToString(Timestamp value) {
        return value != null ? this.calendarFormatProvider.getDatetimeFormat().format(value) : "";
    }

    @Override
    public Timestamp parsDate(String rawData) throws Exception {
        return StringUtils.isNotEmpty((String)rawData) ? new Timestamp(this.calendarFormatProvider.getDateFormat().parse(rawData).getTime()) : null;
    }

    @Override
    public String dateToString(Timestamp value) {
        return value != null ? this.calendarFormatProvider.getDateFormat().format(value) : "";
    }
}

