/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers.validators;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.war.cascade.InputControlValidationException;
import com.jaspersoft.jasperserver.war.cascade.handlers.validators.ComparableValidator;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class StringValueValidator
extends ComparableValidator<String> {
    @Resource
    protected MessageSource messageSource;

    @Override
    public void validateSingleValue(String value, DataType dataType) throws InputControlValidationException {
        if (dataType != null && value != null) {
            Locale locale = LocaleContextHolder.getLocale();
            if (dataType.getMaxLength() != null && value.length() > dataType.getMaxLength()) {
                throw new InputControlValidationException("fillParameters.error.fieldTooLong", null, this.messageSource.getMessage("fillParameters.error.fieldTooLong", null, locale), null);
            }
            if (dataType.getRegularExpr() != null && dataType.getRegularExpr().trim().length() > 0 && value.length() > 0 && !Pattern.matches(dataType.getRegularExpr(), value)) {
                throw new InputControlValidationException("fillParameters.error.invalidPattern", null, this.messageSource.getMessage("fillParameters.error.invalidPattern", null, locale), null);
            }
            super.validateSingleValue(value, dataType);
        }
    }
}

