/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.common;

import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementDisjunction;
import com.jaspersoft.jasperserver.api.metadata.view.domain.PropertyFilter;
import com.jaspersoft.jasperserver.war.common.HeartbeatClientInfo;
import com.jaspersoft.jasperserver.war.common.HeartbeatContributor;
import com.jaspersoft.jasperserver.war.common.HeartbeatCustomDSInfo;
import com.jaspersoft.jasperserver.war.common.HeartbeatDatabaseInfo;
import com.jaspersoft.jasperserver.war.common.HeartbeatInfoCache;
import com.jaspersoft.jasperserver.war.common.LocalesList;
import com.jaspersoft.jasperserver.war.common.UserLocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

public class HeartbeatBean
implements ServletContextAware,
HeartbeatContributor {
    private static final Log log = LogFactory.getLog(HeartbeatBean.class);
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_HEARTBEAT_ID = "heartbeat.id";
    private static final String PROPERTY_PERMISSION_GRANTED = "permission.granted";
    private static final HeartbeatContributor OPTOUT_HEARTBEAT_CONTRIBUTOR = new HeartbeatContributor(){

        @Override
        public void contributeToHttpCall(PostMethod post) {
            post.addParameter("callCount", "-1");
        }
    };
    private ServletContext servletContext = null;
    private DataSource dataSource = null;
    private TenantService tenantService = null;
    private RepositoryService repositoryService = null;
    private EngineService engineService = null;
    private LocalesList localesList = null;
    private HeartbeatContributor optionalContributor = null;
    private List<String> customDSClassPatterns;
    private boolean enabled = false;
    private boolean askForPermission = false;
    private boolean permissionGranted = false;
    private String url = null;
    private int maxCacheSize = 0;
    private long cacheSaveInterval = 0L;
    private String localId = null;
    private String heartbeatId = null;
    private int callCount = 0;
    private Properties localIdProperties = new Properties();
    private long lastCacheSaveTime = 0L;
    private String osName = null;
    private String osVersion = null;
    private String javaVendor = null;
    private String javaVersion = null;
    private String serverInfo = null;
    private String productName = null;
    private String productVersion = null;
    private String location = null;
    private String dbName = null;
    private String dbVersion = null;
    private HeartbeatInfoCache clientInfoCache = new HeartbeatInfoCache();
    private HeartbeatInfoCache databaseInfoCache = new HeartbeatInfoCache();
    private HeartbeatInfoCache customDSInfoCache = new HeartbeatInfoCache();

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setEngineService(EngineService engineService) {
        this.engineService = engineService;
    }

    public void setLocalesList(LocalesList localesList) {
        this.localesList = localesList;
    }

    public void setContributor(HeartbeatContributor contributor) {
        this.optionalContributor = contributor;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getAskForPermission() {
        return this.askForPermission;
    }

    public void setAskForPermission(boolean askForPermission) {
        this.askForPermission = askForPermission;
    }

    public boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public long getCacheSaveInterval() {
        return this.cacheSaveInterval;
    }

    public void setCacheSaveInterval(long cacheSaveInterval) {
        this.cacheSaveInterval = cacheSaveInterval;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    private String getLocalId() {
        return this.localId;
    }

    private File getLocalIdFile() {
        File jsHomeDir = new File(new File(System.getProperty("user.home")), ".jasperserver");
        return new File(jsHomeDir, this.getLocalId());
    }

    private File getClientInfoCacheFile() {
        File jsHomeDir = new File(new File(System.getProperty("user.home")), ".jasperserver");
        return new File(jsHomeDir, this.getLocalId() + ".ser");
    }

    public void init() {
        block3: {
            if (this.enabled) {
                try {
                    this.initHeartbeat();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Heartbeat initialization failed.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHeartbeat() {
        block37: {
            this.osName = System.getProperty("os.name");
            this.osVersion = System.getProperty("os.version");
            this.javaVendor = System.getProperty("java.vendor");
            this.javaVersion = System.getProperty("java.version");
            this.serverInfo = this.servletContext.getServerInfo();
            this.location = this.servletContext.getRealPath("/");
            this.dbName = null;
            this.dbVersion = null;
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                this.dbName = metaData.getDatabaseProductName();
                this.dbVersion = metaData.getDatabaseProductVersion();
            }
            catch (SQLException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting database metadata failed.", (Throwable)e);
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
            String idSource = this.serverInfo + "|" + this.productName + "|" + (this.location == null ? "" : this.location);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
            if (messageDigest == null) {
                this.localId = String.valueOf(idSource.hashCode());
            } else {
                byte[] idBytes = messageDigest.digest(idSource.getBytes());
                StringBuffer idBuffer = new StringBuffer(2 * idBytes.length);
                for (int i = 0; i < idBytes.length; ++i) {
                    String hexa = Integer.toHexString(128 + idBytes[i]).toUpperCase();
                    hexa = ("00" + hexa).substring(hexa.length());
                    idBuffer.append(hexa);
                }
                this.localId = idBuffer.toString();
            }
            File localIdFile = this.getLocalIdFile();
            if (localIdFile.exists() && localIdFile.isFile()) {
                this.localIdProperties = new Properties();
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(localIdFile);
                    this.localIdProperties.load(fis);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Loading heartbeat local ID properties file failed.", (Throwable)e);
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            this.heartbeatId = this.localIdProperties.getProperty(PROPERTY_HEARTBEAT_ID);
            File clientInfoCacheFile = this.getClientInfoCacheFile();
            if (clientInfoCacheFile.exists() && clientInfoCacheFile.isFile()) {
                try {
                    this.clientInfoCache = (HeartbeatInfoCache)JRLoader.loadObject((File)clientInfoCacheFile);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block37;
                    log.debug((Object)"Loading heartbeat cache from serialized file failed.", (Throwable)e);
                }
            }
        }
        this.lastCacheSaveTime = System.currentTimeMillis();
    }

    public boolean haveToAskForPermissionNow() {
        return this.enabled && this.getAskForPermission() && (!this.localIdProperties.containsKey(PROPERTY_PERMISSION_GRANTED) || Boolean.valueOf(this.localIdProperties.getProperty(PROPERTY_PERMISSION_GRANTED)) == false && !this.getProductVersion().equals(this.localIdProperties.getProperty(PROPERTY_VERSION)));
    }

    public boolean isMakingCalls() {
        return this.enabled && (this.getAskForPermission() && Boolean.valueOf(this.localIdProperties.getProperty(PROPERTY_PERMISSION_GRANTED)) != false || !this.getAskForPermission() && this.getPermissionGranted());
    }

    public synchronized void permitCall(boolean isCallPermitted) {
        if (this.enabled) {
            this.localIdProperties.setProperty(PROPERTY_PERMISSION_GRANTED, String.valueOf(isCallPermitted));
            this.localIdProperties.setProperty(PROPERTY_VERSION, this.getProductVersion());
            if (this.heartbeatId != null) {
                this.localIdProperties.setProperty(PROPERTY_HEARTBEAT_ID, this.heartbeatId);
            }
            this.saveLocalIdProperties();
            this.httpCall(this.getUrl(), isCallPermitted ? this : OPTOUT_HEARTBEAT_CONTRIBUTOR);
        }
    }

    public synchronized void updateClientInfo(HeartbeatClientInfo info) {
        if (this.isMakingCalls()) {
            this.clientInfoCache.update(info);
            if (this.getMaxCacheSize() > 0 && this.clientInfoCache.size() > this.getMaxCacheSize()) {
                this.httpCall(this.url, this);
            } else if (this.getCacheSaveInterval() > 0L && System.currentTimeMillis() - this.lastCacheSaveTime > this.getCacheSaveInterval()) {
                this.saveCache();
            }
        }
    }

    public synchronized void call() {
        if (this.enabled) {
            if (this.isMakingCalls()) {
                this.createDatabaseInfoCache();
                this.createCustomDSInfoCache();
                this.httpCall(this.getUrl(), this);
            } else if (!(this.getAskForPermission() || this.getPermissionGranted() || this.localIdProperties.containsKey(PROPERTY_PERMISSION_GRANTED))) {
                this.localIdProperties.setProperty(PROPERTY_PERMISSION_GRANTED, "false");
                this.saveLocalIdProperties();
                this.httpCall(this.getUrl(), OPTOUT_HEARTBEAT_CONTRIBUTOR);
            }
            ++this.callCount;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Heartbeat is DISABLED.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void httpCall(String url, HeartbeatContributor contributor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Heartbeat calling: " + url));
        }
        HttpClient httpClient = new HttpClient();
        PostMethod post = new PostMethod(url);
        try {
            int statusCode;
            if (this.heartbeatId != null) {
                post.addParameter("id", this.heartbeatId);
            }
            if (contributor != null) {
                contributor.contributeToHttpCall(post);
            }
            if ((statusCode = httpClient.executeMethod((HttpMethod)post)) == 200) {
                if (this.heartbeatId == null) {
                    this.heartbeatId = post.getResponseBodyAsString();
                    this.heartbeatId = this.heartbeatId == null ? null : this.heartbeatId.trim();
                    this.localIdProperties.setProperty(PROPERTY_HEARTBEAT_ID, this.heartbeatId);
                    this.saveLocalIdProperties();
                }
            } else if (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307) {
                Header header = post.getResponseHeader("location");
                if (header != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Heartbeat listener redirected.");
                    }
                    this.httpCall(header.getValue(), contributor);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Heartbeat listener redirected to unknown destination.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Connecting to heartbeat listener URL failed. Status code: " + statusCode));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connecting to heartbeat listener URL failed.", (Throwable)e);
            }
        }
        finally {
            post.releaseConnection();
            this.clearCache();
        }
    }

    @Override
    public void contributeToHttpCall(PostMethod post) {
        block8: {
            block7: {
                post.addParameter("callCount", String.valueOf(this.callCount));
                post.addParameter("osName", this.osName);
                post.addParameter("osVersion", this.osVersion);
                post.addParameter("javaVendor", this.javaVendor);
                post.addParameter("javaVersion", this.javaVersion);
                post.addParameter("serverInfo", this.serverInfo);
                post.addParameter("productName", this.productName);
                post.addParameter("productVersion", this.productVersion);
                post.addParameter("dbName", this.dbName);
                post.addParameter("dbVersion", this.dbVersion);
                post.addParameter("serverLocale", Locale.getDefault().toString());
                try {
                    post.addParameter("tenants", String.valueOf(this.tenantService.getNumberOfTenants(null)));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Getting number of tenants failed.", (Throwable)e);
                }
            }
            try {
                UserLocale[] userLocales = this.localesList.getUserLocales(Locale.getDefault());
                if (userLocales != null && userLocales.length > 0) {
                    StringBuffer sbuffer = new StringBuffer();
                    for (int i = 0; i < userLocales.length; ++i) {
                        sbuffer.append(", " + userLocales[i].getCode());
                    }
                    post.addParameter("userLocales", sbuffer.substring(2));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"Getting user locales failed.", (Throwable)e);
            }
        }
        this.clientInfoCache.contributeToHttpCall(post);
        this.databaseInfoCache.contributeToHttpCall(post);
        this.customDSInfoCache.contributeToHttpCall(post);
        if (this.optionalContributor != null) {
            this.optionalContributor.contributeToHttpCall(post);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDatabaseInfoCache() {
        ArrayList dataSources;
        block21: {
            block20: {
                this.databaseInfoCache = new HeartbeatInfoCache();
                dataSources = new ArrayList();
                try {
                    List jdbcDataSources = this.repositoryService.loadClientResources(FilterCriteria.createFilter(JdbcReportDataSource.class));
                    if (jdbcDataSources != null) {
                        dataSources.addAll(jdbcDataSources);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debug((Object)"Getting JDBC data sources list failed.", (Throwable)e);
                }
            }
            try {
                List jndiDataSources = this.repositoryService.loadClientResources(FilterCriteria.createFilter(JndiJdbcReportDataSource.class));
                if (jndiDataSources != null) {
                    dataSources.addAll(jndiDataSources);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block21;
                log.debug((Object)"Getting JNDI data sources list failed.", (Throwable)e);
            }
        }
        for (ReportDataSource dataSource : dataSources) {
            Connection connection;
            HashMap paramValues;
            block22: {
                paramValues = new HashMap();
                try {
                    ReportDataSourceService dataSourceService = this.engineService.createDataSourceService(dataSource);
                    dataSourceService.setReportParameterValues(paramValues);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block22;
                    log.debug((Object)"Getting connection to data source failed.", (Throwable)e);
                }
            }
            if ((connection = (Connection)paramValues.get("REPORT_CONNECTION")) == null) continue;
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                HeartbeatDatabaseInfo dbInfo = new HeartbeatDatabaseInfo();
                dbInfo.setDatabaseName(metaData.getDatabaseProductName());
                dbInfo.setDatabaseVersion(metaData.getDatabaseProductVersion());
                this.databaseInfoCache.update(dbInfo);
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Getting database metadata failed.", (Throwable)e);
            }
            finally {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public void createCustomDSInfoCache() {
        block7: {
            this.customDSInfoCache = new HeartbeatInfoCache();
            if (this.customDSClassPatterns != null && !this.customDSClassPatterns.isEmpty()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("fetching custom DS information for patterns " + this.customDSClassPatterns));
                    }
                    FilterCriteria filter = FilterCriteria.createFilter(CustomReportDataSource.class);
                    FilterElementDisjunction classFilters = filter.addDisjunction();
                    for (String classPattern : this.customDSClassPatterns) {
                        PropertyFilter classFilter = FilterCriteria.createPropertyLikeFilter((String)"serviceClass", (Object)classPattern);
                        classFilters.addFilterElement((FilterElement)classFilter);
                    }
                    List dataSources = this.repositoryService.loadClientResources(filter);
                    if (dataSources != null && !dataSources.isEmpty()) {
                        for (CustomReportDataSource dataSource : dataSources) {
                            HeartbeatCustomDSInfo customDSInfo = new HeartbeatCustomDSInfo();
                            customDSInfo.setServiceClass(dataSource.getServiceClass());
                            this.customDSInfoCache.update(customDSInfo);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"Getting custom data sources list failed.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveLocalIdProperties() {
        File localIdFile = this.getLocalIdFile();
        if (!localIdFile.exists()) {
            localIdFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(localIdFile);
            this.localIdProperties.store(fos, "heartbeat local ID file");
            fos.flush();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating heartbeat local ID properties file failed.", (Throwable)e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized void saveCache() {
        block3: {
            File clientInfoCacheFile = this.getClientInfoCacheFile();
            if (!clientInfoCacheFile.exists()) {
                clientInfoCacheFile.getParentFile().mkdirs();
            }
            try {
                JRSaver.saveObject((Object)this.clientInfoCache, (File)clientInfoCacheFile);
                this.lastCacheSaveTime = System.currentTimeMillis();
            }
            catch (JRException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Saving heartbeat cache failed.", (Throwable)e);
            }
        }
    }

    private synchronized void clearCache() {
        this.clientInfoCache = new HeartbeatInfoCache();
        this.getClientInfoCacheFile().delete();
        this.lastCacheSaveTime = System.currentTimeMillis();
    }

    public List<String> getCustomDSClassPatterns() {
        return this.customDSClassPatterns;
    }

    public void setCustomDSClassPatterns(List<String> customDSClassPatterns) {
        this.customDSClassPatterns = customDSClassPatterns;
    }
}

