/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.MessageSource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class LogSettingsController
implements Controller,
ResourceLoaderAware {
    private static Logger log = Logger.getLogger(LogSettingsController.class);
    private Map<Locale, Map<String, String>> loggerDescriptionsByLocale = Collections.synchronizedMap(new HashMap());
    private Map<String, String> loggers = Collections.synchronizedMap(new LinkedHashMap());
    private List<String> loggerDescriptionFiles;
    private ResourceLoader resourceLoader;
    private MessageSource messageSource;

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String loggerArg = request.getParameter("logger");
        String levelArg = request.getParameter("level");
        this.initLoggers();
        this.initLoggerDescriptions();
        if (loggerArg != null && levelArg != null) {
            Logger log = Logger.getLogger((String)loggerArg);
            log.setLevel(Level.toLevel((String)levelArg));
            this.loggers.put(loggerArg, levelArg);
        }
        for (String l : this.loggers.keySet()) {
            Logger log = Logger.getLogger((String)l);
            Level level = log.getEffectiveLevel();
            this.loggers.put(l, level.toString());
        }
        ModelAndView mav = new ModelAndView("modules/administer/logSettings");
        mav.addObject("loggers", this.loggers);
        mav.addObject("loggerDesc", this.loggerDescriptionsByLocale.get(LocaleContextHolder.getLocale()));
        return mav;
    }

    private void initLoggers() {
        if (this.loggers.isEmpty()) {
            if (this.loggerDescriptionFiles == null || this.loggerDescriptionFiles.isEmpty()) {
                throw new IllegalStateException("No logger description files specified.");
            }
            for (String file : this.loggerDescriptionFiles) {
                try {
                    String props = this.loadWebappFile(file);
                    if (props == null) continue;
                    Properties p = new Properties();
                    p.load(new ByteArrayInputStream(props.getBytes()));
                    for (Object key : p.keySet()) {
                        this.loggers.put((String)key, null);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)"problem loading log descriptions", (Throwable)e);
                }
            }
        }
    }

    private void initLoggerDescriptions() {
        Locale locale = LocaleContextHolder.getLocale();
        if (!this.loggerDescriptionsByLocale.containsKey(locale)) {
            LinkedHashMap<String, String> loggerDescriptions = new LinkedHashMap<String, String>();
            for (String key : this.loggers.keySet()) {
                loggerDescriptions.put(key, this.messageSource.getMessage(key, null, "", locale));
            }
            this.loggerDescriptionsByLocale.put(locale, loggerDescriptions);
        }
    }

    private String loadWebappFile(String path) throws IOException {
        int n;
        Resource test = this.resourceLoader.getResource(path);
        InputStream is = test.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((n = is.read(bytes)) > 0) {
            baos.write(bytes, 0, n);
        }
        return baos.toString();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setLoggerDescriptionFiles(List<String> loggerDescriptionFiles) {
        this.loggerDescriptionFiles = loggerDescriptionFiles;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

