/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.control.interceptor;

import com.jaspersoft.jasperserver.api.JSException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RenderViewExceptionInterceptor
extends HandlerInterceptorAdapter {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private MessageSource messageSource;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            String message;
            Locale locale = LocaleContextHolder.getLocale();
            if (ex instanceof JSException) {
                JSException jsException = (JSException)ex;
                message = this.messageSource.getMessage(ex.getMessage(), jsException.getArgs(), locale);
            } else {
                message = this.messageSource.getMessage("error.500.message", null, locale);
            }
            this.log.error((Object)message, (Throwable)ex);
            response.sendError(500, message);
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

