/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataFilter;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.List;
import org.json.JSONException;

public class RepositoryTreeDataProviderImpl
implements TreeDataProvider {
    private RepositoryService repositoryService;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;
    private TreeDataFilter filter;

    @Override
    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode n = this.getNode(executionContext, parentUri, depth + 1);
        if (n != null) {
            return n.getChildren();
        }
        return null;
    }

    @Override
    public TreeNode getNode(ExecutionContext executionContext, String uri, int depth) {
        Resource resource = this.repositoryService.getResource(executionContext, uri);
        if (resource != null) {
            return this.createNode(resource, false);
        }
        Folder folder = this.repositoryService.getFolder(executionContext, uri);
        if (folder != null) {
            TreeNode node = this.createNode((Resource)folder, true);
            if (depth > 0) {
                this.processFolder(node, depth - 1);
            }
            return node;
        }
        return null;
    }

    private TreeNode createNode(Resource resource, boolean isFolder) {
        Permissions extraProperty = new Permissions();
        extraProperty.isWritable = this.repositoryServiceSecurityChecker.isEditable(resource);
        extraProperty.isRemovable = this.repositoryServiceSecurityChecker.isRemovable(resource);
        if (isFolder) {
            return new TreeNodeImpl(this, resource.getName(), resource.getLabel(), resource.getResourceType(), resource.getURIString(), 1, extraProperty);
        }
        return new TreeNodeImpl((TreeDataProvider)this, resource.getName(), resource.getLabel(), resource.getResourceType(), resource.getURIString(), extraProperty);
    }

    private void processFolder(TreeNode folder, int depth) {
        TreeNode n;
        String folderURI = folder.getUriString();
        FilterCriteria criteria = FilterCriteria.createFilter();
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
        List folders = this.repositoryService.getSubFolders(null, folderURI);
        List resources = this.repositoryService.loadResourcesList(null, criteria);
        if (folders != null) {
            for (Folder f : folders) {
                n = this.createNode((Resource)f, true);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
                if (depth <= 0) continue;
                this.processFolder(n, depth - 1);
            }
        }
        if (resources != null) {
            for (Resource r : resources) {
                n = this.createNode(r, false);
                if (this.filter != null && !this.filter.filter(n)) continue;
                folder.getChildren().add(n);
            }
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public TreeDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeDataFilter filter) {
        this.filter = filter;
    }

    private static class Permissions
    implements JSONObject {
        public boolean isWritable = true;
        public boolean isRemovable = true;

        private Permissions() {
        }

        @Override
        public String toJSONString() {
            org.json.JSONObject jsonObject = new org.json.JSONObject();
            try {
                jsonObject.put("isWritable", this.isWritable);
                jsonObject.put("isRemovable", this.isRemovable);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jsonObject.toString();
        }
    }
}

