/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.ScaleOpImage;

public final class ScaleBilinearBinaryOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleBilinearBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n6];
        long l = n3;
        long l2 = 1L;
        long l3 = n4;
        long l4 = 1L;
        l = l * this.transXRationalDenom - this.transXRationalNum * l2;
        l3 = l3 * this.transYRationalDenom - this.transYRationalNum * l4;
        l = 2L * l + (l2 *= this.transXRationalDenom);
        l2 *= 2L;
        l3 = 2L * l3 + (l4 *= this.transYRationalDenom);
        l4 *= 2L;
        l *= this.invScaleXRationalNum;
        l3 *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleXRationalDenom);
        l3 = 2L * l3 - (l4 *= this.invScaleYRationalDenom);
        l4 *= 2L;
        int n7 = Rational.floor(l, l2 *= 2L);
        long l5 = l % l2;
        if (n7 < 0) {
            l5 = l2 + l5;
        }
        int n8 = Rational.floor(l3, l4);
        long l6 = l3 % l4;
        if (n8 < 0) {
            l6 = l4 + l6;
        }
        long l7 = l2 * this.invScaleXRationalDenom;
        l5 *= this.invScaleXRationalDenom;
        long l8 = this.invScaleXFrac * l2;
        long l9 = l4 * this.invScaleYRationalDenom;
        l6 *= this.invScaleYRationalDenom;
        long l10 = this.invScaleYFrac * l4;
        int n9 = 0;
        while (n9 < n5) {
            nArray[n9] = n7;
            nArray3[n9] = (int)((float)l5 / (float)l7 * (float)this.one);
            n7 = (int)((long)n7 + this.invScaleXInt);
            if ((l5 += l8) >= l7) {
                ++n7;
                l5 -= l7;
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < n6) {
            nArray2[n10] = n8;
            nArray4[n10] = (int)((float)l6 / (float)l9 * (float)this.one);
            n8 = (int)((long)n8 + this.invScaleYInt);
            if ((l6 += l10) >= l9) {
                ++n8;
                l6 -= l9;
            }
            ++n10;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, n3, n4, n5, n6, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, n3, n4, n5, n6, nArray, nArray2, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, n3, n4, n5, n6, nArray, nArray2, nArray3, nArray4);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n11 = writableRaster.getMinX();
        int n12 = writableRaster.getMinY();
        int n13 = writableRaster.getSampleModelTranslateX();
        int n14 = writableRaster.getSampleModelTranslateY();
        int n15 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n16 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n17 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n18 = dataBufferByte2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n19 = 0;
        while (n19 < n3) {
            n6 = nArray[n19];
            n5 = n9 + (n6 - n7);
            nArray5[n19] = n5 >> 3;
            nArray6[n19] = 7 - (n5 & 7);
            ++n19;
        }
        int n20 = 0;
        int n21 = 0;
        int n22 = (n2 - n14) * n16 + n18;
        int n23 = n15 + (n - n13);
        int n24 = 0;
        int n25 = 0;
        n25 = 0;
        while (n25 < n4) {
            n21 = nArray2[n25];
            int n26 = nArray4[n25];
            n6 = (n21 - n8) * n10 + n17;
            n23 = n15 + (n - n13);
            n24 = 0;
            while (n24 < n3) {
                int n27 = nArray3[n24];
                n20 = nArray[n24];
                int n28 = n9 + (n20 + 1 - n7);
                int n29 = n28 >> 3;
                int n30 = 7 - (n28 & 7);
                n5 = byArray[n6 + nArray5[n24]] >> nArray6[n24] & 1;
                int n31 = byArray[n6 + n29] >> n30 & 1;
                int n32 = byArray[n6 + n10 + nArray5[n24]] >> nArray6[n24] & 1;
                int n33 = byArray[n6 + n10 + n29] >> n30 & 1;
                int n34 = (n31 - n5) * n27 + (n5 << this.subsampleBits);
                int n35 = (n33 - n32) * n27 + (n32 << this.subsampleBits);
                int n36 = (n35 - n34) * n26 + ((n34 << this.subsampleBits) + this.round2) >> this.shift2;
                int n37 = n23 >> 3;
                int n38 = 7 - (n23 & 7);
                if (n36 == 1) {
                    int n39 = n22 + n37;
                    byArray2[n39] = (byte)(byArray2[n39] | 1 << n38);
                } else {
                    int n40 = n22 + n37;
                    byArray2[n40] = (byte)(byArray2[n40] & 255 - (1 << n38));
                }
                ++n23;
                ++n24;
            }
            n22 += n16;
            ++n25;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        int n11 = writableRaster.getMinX();
        int n12 = writableRaster.getMinY();
        int n13 = writableRaster.getSampleModelTranslateX();
        int n14 = writableRaster.getSampleModelTranslateY();
        int n15 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n16 = multiPixelPackedSampleModel2.getScanlineStride();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n17 = dataBufferUShort.getOffset();
        DataBufferUShort dataBufferUShort2 = (DataBufferUShort)writableRaster.getDataBuffer();
        short[] sArray2 = dataBufferUShort2.getData();
        int n18 = dataBufferUShort2.getOffset();
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n19 = 0;
        while (n19 < n3) {
            n6 = nArray[n19];
            n5 = n9 + (n6 - n7);
            nArray5[n19] = n5 >> 4;
            nArray6[n19] = 15 - (n5 & 0xF);
            ++n19;
        }
        int n20 = (n2 - n14) * n16 + n18;
        int n21 = n15 + (n - n13);
        int n22 = 0;
        while (n22 < n4) {
            int n23 = nArray2[n22];
            int n24 = nArray4[n22];
            n6 = (n23 - n8) * n10 + n17;
            n21 = n15 + (n - n13);
            int n25 = 0;
            while (n25 < n3) {
                int n26 = nArray3[n25];
                int n27 = nArray[n25];
                int n28 = n9 + (n27 + 1 - n7);
                int n29 = n28 >> 4;
                int n30 = 15 - (n28 & 0xF);
                n5 = sArray[n6 + nArray5[n25]] >> nArray6[n25] & 1;
                int n31 = sArray[n6 + n29] >> n30 & 1;
                int n32 = sArray[n6 + n10 + nArray5[n25]] >> nArray6[n25] & 1;
                int n33 = sArray[n6 + n10 + n29] >> n30 & 1;
                int n34 = (n31 - n5) * n26 + (n5 << this.subsampleBits);
                int n35 = (n33 - n32) * n26 + (n32 << this.subsampleBits);
                int n36 = (n35 - n34) * n24 + (n34 << this.subsampleBits) + this.round2 >> this.shift2;
                int n37 = n21 >> 4;
                int n38 = 15 - (n21 & 0xF);
                if (n36 == 1) {
                    int n39 = n20 + n37;
                    sArray2[n39] = (short)(sArray2[n39] | 1 << n38);
                } else {
                    int n40 = n20 + n37;
                    sArray2[n40] = (short)(sArray2[n40] & 65535 - (1 << n38));
                }
                ++n21;
                ++n25;
            }
            n20 += n16;
            ++n22;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6;
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n7 = raster.getSampleModelTranslateX();
        int n8 = raster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n11 = writableRaster.getMinX();
        int n12 = writableRaster.getMinY();
        int n13 = writableRaster.getSampleModelTranslateX();
        int n14 = writableRaster.getSampleModelTranslateY();
        int n15 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n16 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray5 = dataBufferInt.getData();
        int n17 = dataBufferInt.getOffset();
        int[] nArray6 = dataBufferInt2.getData();
        int n18 = dataBufferInt2.getOffset();
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        int n19 = 0;
        while (n19 < n3) {
            n6 = nArray[n19];
            n5 = n9 + (n6 - n7);
            nArray7[n19] = n5 >> 5;
            nArray8[n19] = 31 - (n5 & 0x1F);
            ++n19;
        }
        int n20 = (n2 - n14) * n16 + n18;
        int n21 = n15 + (n - n13);
        int n22 = 0;
        while (n22 < n4) {
            int n23 = nArray2[n22];
            int n24 = nArray4[n22];
            n6 = (n23 - n8) * n10 + n17;
            n21 = n15 + (n - n13);
            int n25 = 0;
            while (n25 < n3) {
                int n26 = nArray3[n25];
                int n27 = nArray[n25];
                int n28 = n9 + (n27 + 1 - n7);
                int n29 = n28 >> 5;
                int n30 = 31 - (n28 & 0x1F);
                n5 = nArray5[n6 + nArray7[n25]] >> nArray8[n25] & 1;
                int n31 = nArray5[n6 + n29] >> n30 & 1;
                int n32 = nArray5[n6 + n10 + nArray7[n25]] >> nArray8[n25] & 1;
                int n33 = nArray5[n6 + n10 + n29] >> n30 & 1;
                int n34 = (n31 - n5) * n26 + (n5 << this.subsampleBits);
                int n35 = (n33 - n32) * n26 + (n32 << this.subsampleBits);
                int n36 = (n35 - n34) * n24 + (n34 << this.subsampleBits) + this.round2 >> this.shift2;
                int n37 = n21 >> 5;
                int n38 = 31 - (n21 & 0x1F);
                if (n36 == 1) {
                    int n39 = n20 + n37;
                    nArray6[n39] = nArray6[n39] | 1 << n38;
                } else {
                    int n40 = n20 + n37;
                    nArray6[n40] = nArray6[n40] & 255 - (1 << n38);
                }
                ++n21;
                ++n25;
            }
            n20 += n16;
            ++n22;
        }
    }
}

