/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.util.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.FTPService;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPUtil
implements FTPService {
    private static final Log log = LogFactory.getLog(FTPUtil.class);

    public FTPService.FTPServiceClient connect(String host, String userName, String password) throws Exception {
        return new FTPServiceClientImpl(host, userName, password);
    }

    public class FTPServiceClientImpl
    implements FTPService.FTPServiceClient {
        private FTPSClient ftpClient = new FTPSClient(false);

        public FTPServiceClientImpl(String host, String userName, String password) throws Exception {
            int reply;
            this.ftpClient.connect(host);
            if (!this.ftpClient.login(userName, password)) {
                this.ftpClient.logout();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FTP:  connected to " + host + " LOGIN OK."));
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = this.ftpClient.getReplyCode()))) {
                this.ftpClient.disconnect();
                throw new JSException("FTP:  unable to connect to " + host);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connected to " + host + " REPLY OK."));
            }
            this.ftpClient.execPBSZ(0L);
            this.ftpClient.execPROT("P");
            this.ftpClient.enterLocalPassiveMode();
        }

        public void disconnect() throws Exception {
            try {
                if (this.ftpClient != null && this.ftpClient.isConnected()) {
                    this.ftpClient.disconnect();
                }
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.ftpClient = null;
            }
        }

        public void changeDirectory(String directoryPath) throws Exception {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Original Working directory = " + this.ftpClient.printWorkingDirectory()));
            }
            if (this.ftpClient == null) {
                throw new JSException("Please connect to FTP server first before changing directory!");
            }
            this.ftpClient.changeWorkingDirectory(directoryPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NEW Working directory = " + this.ftpClient.printWorkingDirectory()));
            }
        }

        public InputStream getFile(String fileName) throws Exception {
            if (this.ftpClient == null) {
                throw new JSException("Please connect to FTP server first before changing directory!");
            }
            return this.ftpClient.retrieveFileStream(fileName);
        }

        public void putFile(String fileName, InputStream inputData) throws Exception {
            if (this.ftpClient == null) {
                throw new JSException("Please connect to FTP server first before changing directory!");
            }
            this.ftpClient.setFileType(2);
            boolean state = this.ftpClient.storeFile(this.ftpClient.printWorkingDirectory() + "/" + fileName, inputData);
            if (!state) {
                throw new JSException("Fail to upload file " + fileName);
            }
        }

        public boolean exists(String fileName) throws Exception {
            if (this.ftpClient == null) {
                throw new JSException("Please connect to FTP server first before changing directory!");
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FTP Working directory = " + this.ftpClient.printWorkingDirectory()));
                }
                FTPFile[] files = this.ftpClient.listFiles(this.ftpClient.printWorkingDirectory());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FTP:  number of files - " + (files == null ? "NULL" : Integer.valueOf(files.length))));
                }
                if (files == null) {
                    return false;
                }
                for (FTPFile ftpFile : files) {
                    if (!ftpFile.getName().equalsIgnoreCase(fileName)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
    }
}

