/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.BaseRepositoryListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.ResourceCopiedEvent;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DataSnapshotReportUnitCopyListener
extends BaseRepositoryListener
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(DataSnapshotReportUnitCopyListener.class);
    private ApplicationContext applicationContext;
    private String dataSnapshotServiceBean;

    public void resourceCopied(ResourceCopiedEvent event) {
        Resource resource = event.getResource();
        if (resource instanceof ReportUnit) {
            ReportUnit report = (ReportUnit)resource;
            this.copyDataSnapshot(event.getSourceUri(), report);
        }
    }

    private void copyDataSnapshot(String sourceUri, ReportUnit report) {
        Long sourceSnapshotId = report.getDataSnapshotId();
        if (sourceSnapshotId != null) {
            DataSnapshotService dataSnapshotService = this.dataSnapshotService();
            if (dataSnapshotService.isSnapshotPersistenceEnabled()) {
                Long snapshotCopyId = dataSnapshotService.copyDataSnapshot(sourceSnapshotId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created snapshot copy " + snapshotCopyId + " for " + report.getURIString() + ", source " + sourceSnapshotId + " of " + sourceUri));
                }
                report.setDataSnapshotId(snapshotCopyId);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("data snapshot persistence disabled, not saving a snapshot for " + report.getURIString() + ", source " + sourceSnapshotId + " of " + sourceUri));
                }
                report.setDataSnapshotId(null);
            }
        }
    }

    protected DataSnapshotService dataSnapshotService() {
        return (DataSnapshotService)this.applicationContext.getBean(this.dataSnapshotServiceBean, DataSnapshotService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getDataSnapshotServiceBean() {
        return this.dataSnapshotServiceBean;
    }

    public void setDataSnapshotServiceBean(String dataSnapshotServiceBean) {
        this.dataSnapshotServiceBean = dataSnapshotServiceBean;
    }
}

