/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.PooledDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.ObjectPoolFactory;

public class DbcpDataSource
implements PooledDataSource {
    private static final Log log = LogFactory.getLog(DbcpDataSource.class);
    private final ObjectPool connectionPool;
    private final PoolingDataSource dataSource;

    public DbcpDataSource(ObjectPoolFactory objectPoolFactory, String url, String username, String password) {
        this(objectPoolFactory, url, username, password, true, false);
    }

    public DbcpDataSource(ObjectPoolFactory objectPoolFactory, String url, String username, String password, boolean defaultReadOnly, boolean defaultAutoCommit) {
        this.connectionPool = this.createPool(objectPoolFactory);
        this.createPoolableConnectionFactory(url, username, password, defaultReadOnly, defaultAutoCommit);
        this.dataSource = new PoolingDataSource(this.connectionPool);
        this.dataSource.setAccessToUnderlyingConnectionAllowed(true);
    }

    protected ObjectPool createPool(ObjectPoolFactory objectPoolFactory) {
        ObjectPool objectPool = objectPoolFactory.createPool();
        return objectPool;
    }

    protected void createPoolableConnectionFactory(String url, String username, String password, boolean defaultReadOnly, boolean defaultAutoCommit) {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, null, null, defaultReadOnly, defaultAutoCommit);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void release() {
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while closing DBCP connection pool", (Throwable)e);
            throw new JSExceptionWrapper(e);
        }
    }

    @Override
    public boolean isActive() {
        return this.connectionPool.getNumActive() > 0;
    }
}

