/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ResourceBundleHelper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;

public class MessageSourceLoader {
    public static MessageSource loadMessageSource(ExecutionContext exContext, ResourceContainer resourceContainer, RepositoryService repository) {
        List resources = resourceContainer.getResources();
        LinkedHashMap<String, RepositoryResourceKey> map = new LinkedHashMap<String, RepositoryResourceKey>();
        LinkedHashSet<String> baseNames = new LinkedHashSet<String>();
        for (ResourceReference resRef : resources) {
            String fileType;
            FileResource resource;
            String fileName;
            Resource genericResource = MessageSourceLoader.getResource(exContext, repository, resRef);
            if (!MessageSourceLoader.isFileResource(genericResource) || !MessageSourceLoader.isBundle(fileName = (resource = (FileResource)genericResource).getName(), fileType = resource.getFileType())) continue;
            map.put(fileName, new RepositoryResourceKey((Resource)resource));
            String baseName = ResourceBundleHelper.getBaseName(fileName);
            if (baseName == null || baseName.length() == 0) continue;
            baseNames.add(baseName);
        }
        if (map.isEmpty()) {
            return null;
        }
        MessageSourceLoader.setupThreadRepositoryContext(exContext, repository);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBundleClassLoader((ClassLoader)new RepositoryResourceClassLoader(Thread.currentThread().getContextClassLoader(), map, false));
        messageSource.setBasenames(baseNames.toArray(new String[baseNames.size()]));
        return messageSource;
    }

    private static boolean isFileResource(Resource genericResource) {
        return FileResource.class.getName().equals(genericResource.getResourceType());
    }

    private static boolean isBundle(String fileName, String fileType) {
        return fileType != null ? fileType.equals("prop") : ResourceBundleHelper.isBundle(fileName);
    }

    private static Resource getResource(ExecutionContext exContext, RepositoryService repository, ResourceReference resourceReference) {
        return resourceReference.isLocal() ? resourceReference.getLocalResource() : repository.getResource(exContext, resourceReference.getReferenceURI());
    }

    private static void setupThreadRepositoryContext(ExecutionContext exContext, RepositoryService repository) {
        if (RepositoryUtil.getThreadRepositoryContext() == null) {
            RepositoryContext rc = new RepositoryContext();
            rc.setRepository(repository);
            rc.setExecutionContext(exContext);
            RepositoryUtil.setThreadRepositoryContext(rc);
        }
    }
}

