/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobAlert;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ExceptionInfo;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJobAlert;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ReportExecutionJobAlertImpl
implements ReportExecutionJobAlert {
    private static final Log log = LogFactory.getLog(ReportExecutionJobAlertImpl.class);

    @Override
    public void sendAlertMail(Job job, ReportJob jobDetails, List<ExceptionInfo> exceptions, JavaMailSender mailSender, String fromAddress, String[] toAddresses, String characterEncoding) throws JobExecutionException {
        ReportJobAlert alert = jobDetails.getAlert();
        boolean isSucceed = exceptions.isEmpty();
        switch (alert.getJobState()) {
            case FAIL_ONLY: {
                if (!isSucceed) break;
                return;
            }
            case SUCCESS_ONLY: {
                if (isSucceed) break;
                return;
            }
            case NONE: {
                return;
            }
        }
        if (alert != null) {
            try {
                String text;
                MimeMessage message = mailSender.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, characterEncoding);
                messageHelper.setFrom(fromAddress);
                String subject = alert.getSubject();
                if (subject == null && job instanceof ReportExecutionJob) {
                    subject = ((ReportExecutionJob)job).getMessage("report.scheduling.job.default.alert.subject", null);
                }
                messageHelper.setSubject(subject);
                StringBuffer messageText = new StringBuffer();
                String string = text = isSucceed ? alert.getMessageText() : alert.getMessageTextWhenJobFails();
                if (text != null) {
                    messageText.append(text);
                }
                messageHelper.setTo(toAddresses);
                if (alert.isIncludingReportJobInfo()) {
                    messageText.append("\n");
                    messageText.append("ReportJob Info:").append("\n");
                    messageText.append("Label = ").append(jobDetails.getLabel()).append("\n");
                    messageText.append("ID = ").append(jobDetails.getId()).append("\n");
                    messageText.append("Description = ").append(jobDetails.getDescription()).append("\n");
                    messageText.append("Status = ").append(exceptions.isEmpty() ? "PASS" : "FAIL").append("\n");
                }
                if (alert.isIncludingStackTrace() && !exceptions.isEmpty()) {
                    for (ExceptionInfo exception : exceptions) {
                        messageText.append("\n");
                        messageText.append(exception.getMessage());
                        ReportExecutionJobAlertImpl.attachException(messageHelper, exception);
                    }
                }
                messageHelper.setText(messageText.toString());
                mailSender.send(message);
            }
            catch (MessagingException e) {
                log.error((Object)"Error while sending report job alert notification", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }

    protected static void attachException(MimeMessageHelper messageHelper, ExceptionInfo exceptionInfo) throws MessagingException {
        Throwable exception = exceptionInfo.getException();
        if (exception == null) {
            return;
        }
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(bufOut);
        exception.printStackTrace(printOut);
        printOut.flush();
        String attachmentName = "exception_" + System.identityHashCode(exception) + ".txt";
        messageHelper.addAttachment(attachmentName, (InputStreamSource)new ByteArrayResource(bufOut.toByteArray()));
    }
}

