/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseExportTestCaseTestNG
extends BaseServiceSetupTestNG {
    protected static Log m_logger = LogFactory.getLog(BaseExportTestCaseTestNG.class);
    protected static final String TEST_BASE_DIR = "target";
    protected static final String EXPORT_COMMAND_BEAN_NAME = "exportCommandBean";
    protected static final String IMPORT_COMMAND_BEAN_NAME = "importCommandBean";
    protected static final String PARAM_EXPORT_DIR = "output-dir";
    protected static final String PARAM_EXPORT_URIS = "uris";
    protected static final String PARAM_EXPORT_REPORT_JOB_URIS = "report-jobs";
    protected static final String PARAM_EXPORT_USERS = "users";
    protected static final String PARAM_EXPORT_ROLES = "roles";
    protected static final String PARAM_IMPORT_DIR = "input-dir";
    protected static final String PARAM_IMPORT_ZIP = "input-zip";
    protected static final String PARAM_IMPORT_PREPEND_PATH = "prepend-path";
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static final Random m_random = new Random(System.currentTimeMillis());
    private List m_exportFolders = new ArrayList();

    public BaseExportTestCaseTestNG() {
        m_logger.info((Object)"BaseExportTestCaseTestNG => constructor() called");
    }

    public void onSetUp() throws Exception {
        m_logger.info((Object)"BaseExportTestCaseTestNG => onSetUp() called");
        this.m_exportFolders.clear();
    }

    public void onTearDown() throws Exception {
        m_logger.info((Object)"BaseExportTestCaseTestNG => onTearDown() called");
        this.deleteExportFolders();
    }

    protected void deleteExportFolders() {
        for (String folder : this.m_exportFolders) {
            this.deleteFolder(new File(folder));
        }
    }

    protected void deleteFolder(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            File[] subFiles = folder.listFiles();
            if (subFiles != null) {
                for (int i = 0; i < subFiles.length; ++i) {
                    File subFile = subFiles[i];
                    if (subFile.isFile()) {
                        m_logger.info((Object)("BaseExportTestCaseTestNG => deleteFolder() is deleting export file " + folder.getName() + "/" + subFile.getName()));
                        subFile.delete();
                        continue;
                    }
                    if (!subFile.isDirectory()) continue;
                    this.deleteFolder(subFile);
                }
            }
            m_logger.info((Object)("BaseExportTestCaseTestNG => deleteFolder() is deleting export folder " + folder.getName()));
            folder.delete();
        }
    }

    protected String createExportDir() {
        String dir = TEST_BASE_DIR + FILE_SEPARATOR + "export_" + m_random.nextInt();
        m_logger.info((Object)("BaseExportTestCaseTestNG => createExportDir() is adding export directory " + dir));
        this.m_exportFolders.add(dir);
        return dir;
    }
}

