/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.TenantImpl;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CoreDataCreateTestNG
extends BaseServiceSetupTestNG {
    protected final Log m_logger = LogFactory.getLog(CoreDataCreateTestNG.class);
    SessionFactory m_sessionFactory;
    HibernateTemplate m_template;
    HibernateDaoSupport m_jasperServerDao;

    public HibernateDaoSupport getJasperServerDao() {
        return this.m_jasperServerDao;
    }

    @Resource(name="jasperServerDao")
    public void setJasperServerDao(HibernateDaoSupport jasperServerDao) {
        this.m_logger.info((Object)"setJasperServerDao() called");
        this.m_jasperServerDao = jasperServerDao;
    }

    public SessionFactory getSessionFactory() {
        return this.m_sessionFactory;
    }

    @Resource(name="sessionFactory")
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.m_logger.info((Object)"setSessionFactory() called");
        this.m_sessionFactory = sessionFactory;
    }

    @BeforeClass
    public void onSetUp() throws Exception {
        this.m_logger.info((Object)"onSetUp() called");
        Session s = this.m_sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)this.m_sessionFactory, (Object)new SessionHolder((org.hibernate.Session)s));
        this.m_template = this.m_jasperServerDao.getHibernateTemplate();
    }

    @AfterClass
    public void onTearDown() {
        this.m_logger.info((Object)"onTearDown() called");
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.m_sessionFactory);
        org.hibernate.Session s = holder.getSession();
        s.flush();
        TransactionSynchronizationManager.unbindResource((Object)this.m_sessionFactory);
        SessionFactoryUtils.releaseSession((org.hibernate.Session)s, (SessionFactory)this.m_sessionFactory);
    }

    @Test
    public void createCoreDataResources() throws Exception {
        this.m_logger.info((Object)"createCoreDataResources() called");
        this.createRootFolder();
        this.createTenantForRoot();
        this.createUsersAndRoles();
        this.createDefaultTheme();
    }

    private void createRootFolder() {
        this.m_logger.info((Object)"createRootFolder() called");
        RepoFolder root = new RepoFolder();
        root.setCreationDate(new Date());
        root.setUpdateDate(new Date());
        root.setName("/");
        root.setLabel("root");
        root.setDescription("Root of the folder hierarchy");
        root.setURI("/");
        root.setHidden(false);
        root.setParent(null);
        this.m_template.save((Object)root);
    }

    private void createTenantForRoot() {
        this.m_logger.info((Object)"createTenantForRoot() called");
        this.createTenant("", "organizations", "root", "organizations", " ", "/", "/", "default");
    }

    private void createTenant(String parentTenantId, String tenantId, String tenantName, String tenantDesc, String tenantNote, String relativeUri, String uri, String theme) {
        TenantImpl aTenant = new TenantImpl();
        if (!"organizations".equals(tenantId) && !"organizations".equals(parentTenantId)) {
            tenantId = parentTenantId + "_" + tenantId;
        }
        aTenant.setParentId(parentTenantId);
        aTenant.setId(tenantId);
        aTenant.setAlias(tenantId);
        aTenant.setTenantName(tenantName);
        aTenant.setTenantDesc(tenantDesc);
        aTenant.setTenantNote(tenantNote);
        aTenant.setTenantUri(relativeUri);
        aTenant.setTenantFolderUri(uri);
        aTenant.setTheme(theme);
        this.getTenantService().putTenant(null, (Tenant)aTenant);
    }

    private void createUsersAndRoles() {
        this.m_logger.info((Object)"createUsersAndRoles() called");
        User jasperadmin = this.createUser("jasperadmin", "jasperadmin", "jasperadmin User");
        Role roleAdministrator = this.createRole("ROLE_ADMINISTRATOR");
        this.addRole(jasperadmin, "ROLE_ADMINISTRATOR");
        Role roleUser = this.createRole("ROLE_USER");
        this.addRole(jasperadmin, "ROLE_USER");
        this.createObjectPermission("/", roleAdministrator, SimpleAclEntry.ADMINISTRATION);
        this.createObjectPermission("/", roleUser, SimpleAclEntry.READ);
        User anonUser = this.createUser("anonymousUser", null, "anonymousUser");
        this.createRole("ROLE_ANONYMOUS");
        this.addRole(anonUser, "ROLE_ANONYMOUS");
        this.setAuthenticatedUser("jasperadmin");
    }

    private void createDefaultTheme() throws Exception {
        this.m_logger.info((Object)"createDefaultTheme() called");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("theme_files_list.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String filePath = null;
        this.getOrCreateFolder("/", "themes", "Themes");
        Role userRole = this.getRole("ROLE_USER");
        this.createObjectPermission("/themes", userRole, JasperServerAclEntry.EXECUTE);
        HashSet<String> themes = new HashSet<String>();
        while ((filePath = reader.readLine()) != null) {
            int l = "themes/".length();
            String themeName = filePath.substring(l, filePath.indexOf("/", l));
            if (!themes.contains(themeName)) {
                Thread.sleep(1000L);
                themes.add(themeName);
                this.m_logger.info((Object)("createDefaultTheme() => Importing " + themeName));
            }
            InputStream fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            this.createThemeFile(filePath, fileInputStream);
            fileInputStream.close();
        }
        reader.close();
        Role adminRole = this.getRole("ROLE_ADMINISTRATOR");
        ObjectPermission objPerm = this.createObjectPermission("/themes/default", adminRole, SimpleAclEntry.READ);
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        executionContext.getAttributes().add("PRIVILEGED_OPERATION");
        this.getObjectPermissionService().putObjectPermission(executionContext, objPerm);
    }

    private void createThemeFile(String filePath, InputStream fileInputStream) throws Exception {
        int length = fileInputStream.available();
        byte[] data = new byte[length];
        int off = 0;
        while ((off += fileInputStream.read(data, off, length - off)) < length) {
        }
        String[] pathParts = filePath.split("/");
        Folder parentFolder = null;
        String baseFolderURI = "";
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (parentFolder != null) {
                baseFolderURI = parentFolder.getURIString();
            }
            parentFolder = this.getOrCreateFolder(baseFolderURI, pathParts[i]);
        }
        String fileName = pathParts[pathParts.length - 1];
        FileResource fileResource = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        fileResource.setName(fileName);
        fileResource.setLabel(fileName);
        fileResource.setParentFolder(parentFolder);
        Date now = new Date();
        fileResource.setCreationDate(now);
        fileResource.setUpdateDate(now);
        fileResource.setData(data);
        String type = fileName.toUpperCase().endsWith(".CSS") ? "css" : "img";
        fileResource.setFileType(type);
        this.m_logger.info((Object)("createThemeFile() => creating file : " + fileResource.getURIString()));
        this.getRepositoryService().saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)fileResource);
    }
}

