/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.ReportSchedulingInternalService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ContentResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.test.BaseExportTestCaseTestNG;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExportCoreObjectsTestTestNG
extends BaseExportTestCaseTestNG {
    private static final Log m_logger = LogFactory.getLog(ExportCoreObjectsTestTestNG.class);
    private static final String REPORT_SCHEDULING_SERVICE_BEAN_NAME = "reportSchedulingService";
    private static final String REPORT_SCHEDULING_INTERNAL_SERVICE_BEAN_NAME = "reportSchedulingInternalService";
    static final String PATH_SEP = "/";
    static final String LABEL = "_label";
    static final String DESC = "_description";
    static final String DESC_TEXT = " for export-import testing";
    static final String FOLDER_NAME = "exportTest03";
    static final String IMAGE_NAME = "ExportTestImage03";
    private OlapConnectionService m_olapConn;
    private ReportSchedulingService m_sched;
    private ReportSchedulingInternalService m_reportSchedulerInternal;
    private ExecutionContext context;
    private long mJobId;
    private RepositoryService m_repo;
    static final String FOLDER_NAME_SINGLE = "exportTestSingle_01";
    static final String CONTENT_NAME_PDF_SINGLE = "ContentResourcePdf_01";
    static final String FOLDER_NAME_HTML_SINGLE = "exportTestSingle_05";
    static final String CONTENT_NAME_HTML_SINGLE = "ContentResourceHtml_05";
    static final String RU_FOLDER = "exportTestJobSingle_BBB";
    static final String RU_NAME = "TestRUForJob";
    static final String RU_REPORT_NAME = "TestRUReport";
    static final String RU_IMAGE_NAME = "TestRUImage";
    static final String RU_JNDI_NAME = "TestJNDIDS";
    static final String RU_FOLDER_PATH = "/exportTestJobSingle_BBB";
    static final String RU_URI = "/exportTestJobSingle_BBB/TestRUForJob";
    static final String RU_JNDI_URI = "/exportTestJobSingle_BBB/TestJNDIDS";
    static final String DEST_FOLDER = "scheduled";

    public ExportCoreObjectsTestTestNG() {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => constructor() called");
    }

    @Override
    @BeforeClass
    public void onSetUp() throws Exception {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => onSetUp() called");
        super.onSetUp();
        this.m_repo = (RepositoryService)this.getBean("repositoryService");
        this.m_olapConn = (OlapConnectionService)this.getBean("olapConnectionService");
        this.m_sched = (ReportSchedulingService)this.getBean(REPORT_SCHEDULING_SERVICE_BEAN_NAME);
        this.m_reportSchedulerInternal = (ReportSchedulingInternalService)this.getBean(REPORT_SCHEDULING_INTERNAL_SERVICE_BEAN_NAME);
    }

    @Override
    @AfterClass
    public void onTearDown() throws Exception {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => onTearDown() called");
        super.onTearDown();
    }

    @Test
    public void doCoreObject_SetOneTest() {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => doCoreObject_SetOneTest() called");
        this.createResource();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/exportTest03");
        this.performExport(exportParams);
        this.deleteResource();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        this.deleteResource();
    }

    @Test(dependsOnMethods={"doCoreObject_SetOneTest"})
    public void doContentResourcePdf_SingleTest() {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => doContentResourcePdf_SingleTest() called");
        this.createResourceSingle();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/exportTestSingle_01/ContentResourcePdf_01");
        this.performExport(exportParams);
        this.deleteResourceSingle();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        this.deleteResourceSingle();
    }

    private void createResourceSingle() {
        FolderImpl folder = new FolderImpl();
        folder.setName(FOLDER_NAME_SINGLE);
        folder.setLabel("exportTestSingle_01_label");
        folder.setDescription("exportTestSingle_01_description");
        folder.setParentFolder(PATH_SEP);
        this.m_repo.saveFolder(null, (Folder)folder);
        ContentResourceImpl cont1 = new ContentResourceImpl();
        cont1.setName(CONTENT_NAME_PDF_SINGLE);
        cont1.setLabel(CONTENT_NAME_PDF_SINGLE);
        cont1.setParentFolder((Folder)folder);
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("/FontsReport.pdf");
        cont1.readData(file);
        cont1.setFileType("pdf");
        this.m_repo.saveResource(null, (Resource)cont1);
    }

    private void deleteResourceSingle() {
        this.m_repo.deleteResource(null, "/exportTestSingle_01/ContentResourcePdf_01");
        this.m_repo.deleteFolder(null, "/exportTestSingle_01");
    }

    @Test(dependsOnMethods={"doContentResourcePdf_SingleTest"})
    public void doContentResourceHtml_SingleTest() {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => doContentResourceHtml_SingleTest() called");
        this.createResourceSingleHtml();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/exportTestSingle_05/ContentResourceHtml_05");
        this.performExport(exportParams);
        this.deleteResourceSingleHtml();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        ContentResource cr1 = (ContentResource)this.m_repo.getResource(null, "/exportTestSingle_05/ContentResourceHtml_05");
        AssertJUnit.assertNotNull((Object)cr1);
        AssertJUnit.assertEquals((String)cr1.getName(), (String)CONTENT_NAME_HTML_SINGLE);
        this.deleteResourceSingleHtml();
    }

    private void createResourceSingleHtml() {
        FolderImpl folder = new FolderImpl();
        folder.setName(FOLDER_NAME_HTML_SINGLE);
        folder.setLabel("exportTestSingle_05_label");
        folder.setDescription("exportTestSingle_05_description");
        folder.setParentFolder(PATH_SEP);
        this.m_repo.saveFolder(null, (Folder)folder);
        ContentResourceImpl cont1 = new ContentResourceImpl();
        cont1.setName(CONTENT_NAME_HTML_SINGLE);
        cont1.setLabel(CONTENT_NAME_HTML_SINGLE);
        cont1.setParentFolder((Folder)folder);
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html");
        cont1.readData(file);
        cont1.setFileType("html");
        ArrayList<ContentResourceImpl> imagesList = new ArrayList<ContentResourceImpl>();
        ContentResourceImpl image = new ContentResourceImpl();
        image.setName("img_0_0_1");
        image.setLabel("img_0_0_1");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_0_1");
        image.readData(file);
        image.setFileType("html");
        imagesList.add(image);
        image = new ContentResourceImpl();
        image.setName("img_0_7_125");
        image.setLabel("img_0_7_125");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/img_0_7_125");
        image.readData(file);
        image.setFileType("html");
        imagesList.add(image);
        image = new ContentResourceImpl();
        image.setName("px");
        image.setLabel("px");
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html_files/px");
        image.readData(file);
        image.setFileType("html");
        imagesList.add(image);
        cont1.setResources(imagesList);
        this.m_repo.saveResource(null, (Resource)cont1);
    }

    private void deleteResourceSingleHtml() {
        this.m_repo.deleteResource(null, "/exportTestSingle_05/ContentResourceHtml_05");
        this.m_repo.deleteFolder(null, "/exportTestSingle_05");
    }

    private void createResource() {
        FolderImpl folder = new FolderImpl();
        folder.setName(FOLDER_NAME);
        folder.setLabel("exportTest03_label");
        folder.setDescription("exportTest03_description");
        folder.setParentFolder(PATH_SEP);
        this.m_repo.saveFolder(null, (Folder)folder);
        FileResource img1 = (FileResource)this.m_repo.newResource(null, FileResource.class);
        img1.setFileType("img");
        img1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        img1.setName(IMAGE_NAME);
        img1.setLabel("ExportTestImage03_label");
        img1.setDescription("ExportTestImage03_description");
        img1.setParentFolder((Folder)folder);
        this.m_repo.saveResource(null, (Resource)img1);
        ContentResourceImpl cont1 = new ContentResourceImpl();
        cont1.setName("PdfTestFile");
        cont1.setLabel("Pdf test file");
        cont1.setParentFolder((Folder)folder);
        InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("/FontsReport.pdf");
        cont1.readData(file);
        cont1.setFileType("pdf");
        this.m_repo.saveResource(null, (Resource)cont1);
        ContentResourceImpl htmlFile = new ContentResourceImpl();
        htmlFile.setName("HtmlTestFile");
        htmlFile.setLabel("HTML test file with images");
        htmlFile.setParentFolder((Folder)folder);
        file = ((Object)((Object)this)).getClass().getResourceAsStream("/FirstJasper.html");
        htmlFile.readData(file);
        htmlFile.setFileType("html");
        this.m_repo.saveResource(null, (Resource)htmlFile);
    }

    private void deleteResource() {
        this.m_repo.deleteFolder(null, "/exportTest03");
    }

    public void doContentResourceJobSchedule_SingleTest() throws Exception {
        m_logger.info((Object)"ExportCoreObjectsTestTestNG => doContentResourceJobSchedule_SingleTest() called");
        this.deleteSingleJob();
        this.createSingleJob();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", RU_FOLDER_PATH).addParameterValue("report-jobs", RU_URI);
        this.performExport(exportParams);
        this.deleteSingleJob();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        this.deleteSingleJob();
    }

    private void createSingleJob() throws Exception {
        FolderImpl folder = new FolderImpl();
        folder.setName(RU_FOLDER);
        folder.setLabel("exportTestJobSingle_BBB_label");
        folder.setDescription("exportTestJobSingle_BBB_description");
        folder.setParentFolder(PATH_SEP);
        this.m_repo.saveFolder(null, (Folder)folder);
        FolderImpl destFolder = new FolderImpl();
        destFolder.setName(DEST_FOLDER);
        destFolder.setLabel("scheduled_label");
        destFolder.setDescription("scheduled_description");
        destFolder.setParentFolder((Folder)folder);
        this.m_repo.saveFolder(null, (Folder)destFolder);
        ReportUnit unit = (ReportUnit)this.m_repo.newResource(null, ReportUnit.class);
        unit.setName(RU_NAME);
        unit.setLabel("TestRUForJob_label");
        unit.setDescription("Report Unit for export-import testing");
        unit.setParentFolder((Folder)folder);
        if (this.m_repo.getResource(this.context, RU_JNDI_URI) == null) {
            JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.m_repo.newResource(null, JndiJdbcReportDataSource.class);
            datasource.setName(RU_JNDI_NAME);
            datasource.setLabel("TestJNDIDS_label");
            datasource.setDescription("jndi data source for export-import testing");
            datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
            datasource.setParentFolder((Folder)folder);
            this.m_repo.saveResource(null, (Resource)datasource);
        } else {
            JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.m_repo.getResource(this.context, RU_JNDI_URI);
        }
        unit.setDataSourceReference(RU_JNDI_URI);
        FileResource reportRes = (FileResource)this.m_repo.newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName(RU_REPORT_NAME);
        reportRes.setLabel("TestRUReport_label");
        reportRes.setDescription("Report for export-import testing");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TestReportExportImport01.jrxml");
        reportRes.readData(jrxml);
        unit.setMainReport(reportRes);
        FileResource image1 = (FileResource)this.m_repo.newResource(null, FileResource.class);
        image1.setFileType("img");
        image1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image1.setName(RU_IMAGE_NAME);
        image1.setLabel("TestRUImage_label");
        image1.setDescription("Image for export-import testing");
        unit.addResource(image1);
        this.m_repo.saveResource(null, (Resource)unit);
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI(RU_URI);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", new Integer(5));
        params.put("param2", "value2");
        source.setParametersMap(params);
        Date startDate = new Date();
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(startDate);
        trigger.setOccurrenceCount(20);
        trigger.setRecurrenceInterval(10);
        trigger.setRecurrenceIntervalUnit((byte)3);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/exportTestJobSingle_BBB/scheduled");
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job = new ReportJob();
        job.setLabel("JobFor_TestRUForJob_Label");
        job.setDescription("Description");
        job.setSource(source);
        job.setTrigger((ReportJobTrigger)trigger);
        job.setBaseOutputFilename("foo");
        job.addOutputFormat((byte)1);
        job.addOutputFormat((byte)4);
        job.setContentRepositoryDestination(repositoryDestination);
        job.setMailNotification(mailNotification);
        job = this.m_sched.scheduleJob(null, job);
        this.mJobId = job.getId();
    }

    private void deleteSingleJob() {
        Folder folder = this.m_repo.getFolder(null, RU_FOLDER_PATH);
        if (folder != null) {
            this.m_repo.deleteResource(null, RU_URI);
            this.m_repo.deleteFolder(null, RU_FOLDER_PATH);
            this.m_sched.removeScheduledJob(null, this.mJobId);
        }
    }
}

